/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.forum.filters;

import org.ametys.plugins.workspaces.forum.Thread;

/**
 * Filter to check if a thread is closed or not
 */
public class CloseFilter implements ThreadFilter
{
    private Boolean _closed;
    
    /**
     * Filter to check if a thread is closed or not
     * @param closed true to check closed thread, false to check opened threads
     */
    public CloseFilter(Boolean closed) 
    {
        _closed = closed;
    }
    
    public boolean passFilter(Thread thread)
    {
        if (_closed == null)
        {
            return true;
        }
        return _closed == (thread.getCloseDate() != null);
    }
}
