/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.members.observers;

import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.Expression.Operator;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.ObservationConstants;
import org.ametys.plugins.workspaces.WorkspacesConstants;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.observers.AbstractUpdateAclSorCacheObserver;
import org.ametys.web.repository.SiteAwareAmetysObject;

/**
 * This observer reload ACL cache of catalog's and project's contents when a member is added or removed from a project
 */
public class UpdateAclSolrCacheOnMemberUpdatedObserver extends AbstractUpdateAclSorCacheObserver
{
    public boolean supports(Event event)
    {
        String eventId = event.getId();
        return eventId.equals(ObservationConstants.EVENT_MEMBER_ADDED) || eventId.equals(ObservationConstants.EVENT_MEMBER_DELETED)  || eventId.equals(ObservationConstants.EVENT_PROJECT_UPDATED);
    }
    
    @Override
    protected Expression getContentsExpression(Event event, Project project)
    {
        // Read access have changed for project's contents and catalog news
        Expression siteExpression = new StringExpression(SiteAwareAmetysObject.METADATA_SITE, Operator.EQ, project.getSite().getName());
        Expression projectCTypesExpr = new ContentTypeExpression(Operator.EQ, WorkspacesConstants.PROJECT_ARTICLE_CONTENT_TYPE, WorkspacesConstants.WALL_CONTENT_CONTENT_TYPE_ID, WorkspacesConstants.PROJECT_ALERT_CONTENT_TYPE_ID, WorkspacesConstants.PROJECT_NEWS_CONTENT_TYPE_ID);
        Expression projectExpr = new AndExpression(siteExpression, projectCTypesExpr);
        
        Expression catalogCTypesExpr = new ContentTypeExpression(Operator.EQ, WorkspacesConstants.CATALOG_NEWS_CONTENT_TYPE_ID);
        Expression catalogSiteExpr = new StringExpression(SiteAwareAmetysObject.METADATA_SITE, Operator.EQ, _projectManager.getCatalogSiteName());
        Expression catalogExpr =  new AndExpression(catalogSiteExpr, catalogCTypesExpr);
        
        return new OrExpression(catalogExpr, projectExpr);
    }
}
