/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.workspaces.project.generators;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xml.sax.SAXException;

import org.ametys.core.group.GroupIdentity;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.group.GroupHelper;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.projects.MemberAddedActivityType;
import org.ametys.plugins.workspaces.members.JCRProjectMember.MemberType;
import org.ametys.plugins.workspaces.members.MembersWorkspaceModule;

/**
 * Generator for Member Mail notification
 */
public class MemberMailNotifierGenerator extends AbstractMailNotifierGenerator
{
    private GroupHelper _groupHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _groupHelper = (GroupHelper) smanager.lookup(GroupHelper.ROLE);
    }
    @Override
    protected String _getModuleId()
    {
        return MembersWorkspaceModule.MEMBERS_MODULE_ID;
    }

    @Override
    protected void saxAdditionalData(Activity activity) throws SAXException
    {
        MemberType memberType = MemberType.valueOf(activity.<String> getValue(MemberAddedActivityType.MEMBER_TYPE).toUpperCase());
        if (MemberType.USER.equals(memberType))
        {
            UserIdentity userIdentity = UserIdentity.stringToUserIdentity(activity.getValue(MemberAddedActivityType.MEMBER));
            _userHelper.saxUserIdentity(userIdentity, contentHandler);
        }
        else
        {
            GroupIdentity groupIdentity = GroupIdentity.stringToGroupIdentity(activity.getValue(MemberAddedActivityType.MEMBER));
            _groupHelper.saxGroupIdentity(groupIdentity, contentHandler);
        }
    }
}
