/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.tasks.taskexporter;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;

/**
 * Task exporter in ICS format
 */
public class StaticTaskExporter implements TaskExporter, Configurable, PluginAware
{
    
    private static final String __DEFAULT_OPENING_MODE = "openInShareDialog";
    
    /** The name of the plugin that has declared this component */
    protected String _pluginName;

    /** The label to display on list of export */
    protected I18nizableText _listLabel;
    
    /** The label to display in the title */
    protected I18nizableText _titleLabel;
    
    /** The label to display in the description */
    protected I18nizableText _description;
    
    /** The icon */
    protected String _icon;
    
    /** The urlPrefix */
    protected String _urlPrefix;
    
    /** The opening mode */
    protected String _openingMode;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id)
    {
        _pluginName = pluginName;
    }
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        _listLabel = I18nizableText.parseI18nizableText(configuration.getChild("listLabel"), "plugin." + _pluginName);
        _titleLabel = I18nizableText.parseI18nizableText(configuration.getChild("titleLabel"), "plugin." + _pluginName);
        _description = I18nizableText.parseI18nizableText(configuration.getChild("description"), "plugin." + _pluginName);
        _icon = configuration.getChild("icon").getValue("");
        _urlPrefix = configuration.getChild("urlPrefix").getValue("");
        _openingMode = configuration.getChild("openingMode", true).getValue(__DEFAULT_OPENING_MODE);
        
    }
    
    public I18nizableText getListLabel()
    {
        return _listLabel;
    }

    public I18nizableText getTitleLabel()
    {
        return _titleLabel;
    }

    public I18nizableText getDescriptionLabel()
    {
        return _description;
    }

    public String getIcon()
    {
        return _icon;
    }

    public String getUrlCallPrefix()
    {
        return _urlPrefix;
    }

    public String getOpeningMode()
    {
        return _openingMode;
    }
    
}
