/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.util;

import org.ametys.cms.transformation.RichTextTransformer;
import org.ametys.cms.transformation.docbook.DocbookTransformer;

/**
 * {@link RichTextTransformer} which convert HTML into Docbook for {@link Thread}.
 */
public class ThreadDocbookTransformer extends DocbookTransformer
{
    /** Avalon role. */
    public static final String ROLE = ThreadDocbookTransformer.class.getName();

    @Override
    protected String _getSourceUriForRichText2HTML()
    {
        return "cocoon://_plugins/workspaces/convert/docbook2htmleditor";
    }
}
