/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.content.indexing.solr.SolrResourceGroupedMimeTypes;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObject;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tags.ProjectTagsDAO;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.URIPrefixHandler;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WorkspacesHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = WorkspacesHelper.class.getName();
    protected RightManager _rightManager;
    protected WorkspaceModuleExtensionPoint _workspaceModuleEP;
    protected CurrentUserProvider _currentUserProvider;
    private org.apache.avalon.framework.context.Context _context;
    private Context _cocoonContext;
    private URIPrefixHandler _prefixHandler;
    private ProjectTagsDAO _projectTagsDAO;
    private SiteManager _siteManager;
    private ProjectManager _projectManager;
    private UserLanguagesManager _userLanguagesManager;
    private UserManager _userManager;
    private I18nUtils _i18nUtils;
    private WorkspacesHelper _workspacesHelper;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)this._context.get((Object)"environment-context");
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._prefixHandler = (URIPrefixHandler)smanager.lookup(URIPrefixHandler.ROLE);
        this._projectTagsDAO = (ProjectTagsDAO)((Object)smanager.lookup(ProjectTagsDAO.ROLE));
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
        this._workspaceModuleEP = (WorkspaceModuleExtensionPoint)((Object)smanager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)smanager.lookup(UserLanguagesManager.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._workspacesHelper = (WorkspacesHelper)((Object)smanager.lookup(ROLE));
    }

    public boolean isImage(Resource file) {
        return SolrResourceGroupedMimeTypes.getGroup((String)file.getMimeType()).map(groupMimeType -> FileType.IMAGE == FileType.valueOf(groupMimeType.toUpperCase())).orElse(false);
    }

    public FileType getFileType(Resource file) {
        Optional group = SolrResourceGroupedMimeTypes.getGroup((String)file.getMimeType());
        return group.map(groupMimeType -> FileType.valueOf(groupMimeType.toUpperCase())).orElse(FileType.UNKNOWN);
    }

    public FileType getFileType(String filename) {
        String mimeType = this._cocoonContext.getMimeType(filename);
        Optional group = SolrResourceGroupedMimeTypes.getGroup((String)mimeType);
        return group.map(groupMimeType -> FileType.valueOf(groupMimeType.toUpperCase())).orElse(FileType.UNKNOWN);
    }

    public String getAvatar(UserIdentity userIdentity, String lang, int size) {
        StringBuilder sb = new StringBuilder();
        String siteName = WebHelper.getSiteName((Request)this._getRequest());
        sb.append(this._prefixHandler.getUriPrefix(siteName)).append("/_plugins/core-ui/user/").append(userIdentity.getPopulationId()).append("/").append(URIUtils.encodePath((String)userIdentity.getLogin())).append("/image_").append(size).append("?lang=").append(lang);
        return sb.toString();
    }

    private Request _getRequest() {
        return ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context);
    }

    public Project getProjectFromRequest() {
        Site site;
        List<Project> projects;
        Request request = this._getRequest();
        String projectName = (String)request.getAttribute("projectName");
        if (StringUtils.isNotEmpty((CharSequence)projectName)) {
            return this._projectManager.getProject(projectName);
        }
        String siteName = WebHelper.getSiteName((Request)request);
        if (StringUtils.isNotEmpty((CharSequence)siteName) && this._siteManager.hasSite(siteName) && !(projects = this._projectManager.getProjectsForSite(site = this._siteManager.getSite(siteName))).isEmpty()) {
            return projects.get(0);
        }
        return null;
    }

    public List<Map<String, Object>> handleTags(TaggableAmetysObject taggableAmetysObject, List<Object> tags, TraversableAmetysObject moduleRoot) {
        ArrayList<String> createdTags = new ArrayList<String>();
        ArrayList<Map<String, Object>> createdTagsJson = new ArrayList<Map<String, Object>>();
        for (Object tag : tags) {
            if (tag instanceof Map) {
                if (this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Add_Tag", (Object)moduleRoot) != RightManager.RightResult.RIGHT_ALLOW) {
                    throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to handle tags without convenient right.");
                }
                String tagText = (String)((Map)tag).get("text");
                List newTags = this._projectTagsDAO.addTags(new String[]{tagText});
                String newTag = (String)((Map)newTags.get(0)).get("name");
                taggableAmetysObject.tag(newTag);
                createdTags.add(newTag);
                createdTagsJson.addAll(newTags);
                continue;
            }
            taggableAmetysObject.tag((String)tag);
        }
        for (Object tag : taggableAmetysObject.getTags()) {
            if (tags.contains(tag) || createdTags.contains(tag)) continue;
            taggableAmetysObject.untag((String)tag);
        }
        return createdTagsJson;
    }

    public String getLang(Project project) {
        return this.getLang(project, "en");
    }

    public String getLang(Project project, String defaultLanguage) {
        Site site = project.getSite();
        if (site != null) {
            return site.getSitemaps().stream().filter(Objects::nonNull).map(SimpleAmetysObject::getName).findFirst().orElse(defaultLanguage);
        }
        return defaultLanguage;
    }

    public void sendMailToManagers(Project project, String mailFrom, I18nizableText i18nSubject, StandardMailBodyHelper.MailBodyBuilder bodyBuilder, I18nizableText i18nTextBody) throws MessagingException, IOException {
        String defaultLanguage = this._workspacesHelper.getLang(project, this._userLanguagesManager.getDefaultLanguage());
        Map managersToNotifyByLanguage = Arrays.stream(project.getManagers()).map(manager -> this._userManager.getUser(manager)).filter(Objects::nonNull).map(user -> Pair.of((Object)user, (Object)user.getEmail())).filter(p -> StringUtils.isNotEmpty((CharSequence)((CharSequence)p.getRight()))).collect(Collectors.groupingBy(p -> (String)StringUtils.defaultIfBlank((CharSequence)((User)p.getLeft()).getLanguage(), (CharSequence)defaultLanguage), Collectors.mapping(Pair::getRight, Collectors.toList())));
        for (String lang : managersToNotifyByLanguage.keySet()) {
            String subject = this._i18nUtils.translate((I18nizable)i18nSubject, lang);
            String htmlBody = bodyBuilder.withLanguage(lang).build();
            SendMailHelper.MailBuilder mail = SendMailHelper.newMail().withSubject(subject).withHTMLBody(htmlBody).withSender(mailFrom).withRecipients(managersToNotifyByLanguage.get(lang));
            if (i18nTextBody != null) {
                String textBody = this._i18nUtils.translate((I18nizable)i18nTextBody, lang);
                mail.withTextBody(textBody);
            }
            mail.sendMail();
        }
    }

    public static enum FileType {
        TEXT,
        PDF,
        SPREADSHEET,
        PRES,
        IMAGE,
        VIDEO,
        AUDIO,
        ARCHIVE,
        UNKNOWN;

    }
}

