/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.activitystream;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityHelper;
import org.ametys.plugins.repository.activities.ActivityTypeExpression;
import org.ametys.plugins.repository.activities.ActivityTypeExtensionPoint;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.DateExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityType;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ActivityStreamClientInteraction
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ActivityStreamClientInteraction.class.getName();
    public static final String ACTIVITY_STREAM_USER_PREF_CONTEXT = "/workspaces/activity-stream";
    public static final String ACTIVITY_STREAM_USER_PREF_LAST_UPDATE = "lastUpdate";
    private ProjectManager _projectManager;
    private ActivityTypeExtensionPoint _activityTypeExtensionPoint;
    private CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;
    private UserPreferencesManager _userPrefManager;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)serviceManager.lookup(ProjectManager.ROLE));
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._activityTypeExtensionPoint = (ActivityTypeExtensionPoint)serviceManager.lookup(ActivityTypeExtensionPoint.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userPrefManager = (UserPreferencesManager)serviceManager.lookup(UserPreferencesManager.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getActivities(List<String> projectNames, List<String> filterEventTypes, int limit) {
        return this.getActivities(projectNames, filterEventTypes, null, null, null, limit);
    }

    public List<Map<String, Object>> getActivities(List<String> projectNames, List<String> filterEventTypes, ZonedDateTime fromDate, ZonedDateTime untilDate, String pattern, int limit) {
        ArrayList<Map<String, Object>> mergedActivities = new ArrayList<Map<String, Object>>();
        if (projectNames.isEmpty()) {
            return mergedActivities;
        }
        try (AmetysObjectIterable<Activity> activitiesIterable = this._getActivities(projectNames, filterEventTypes, fromDate, untilDate, pattern);){
            if (activitiesIterable != null) {
                List activities = activitiesIterable.stream().limit(Math.round((double)limit + (double)limit * 0.5)).toList();
                mergedActivities.addAll(this._activityTypeExtensionPoint.mergeActivities(activities));
            }
        }
        return mergedActivities.stream().limit(limit).toList();
    }

    private AmetysObjectIterable<Activity> _getActivities(List<String> projectNames, List<String> filterEventTypes, ZonedDateTime fromDate, ZonedDateTime untilDate, String pattern) {
        OrExpression exprs = new OrExpression(new Expression[0]);
        HashSet<String> allAllowedEventTypes = new HashSet<String>();
        for (String projectName : projectNames) {
            Project project = this._projectManager.getProject(projectName);
            Set<String> allowedEventTypes = this._getAllowedEventTypesByProject(project);
            if (filterEventTypes != null && filterEventTypes.size() > 0) {
                allowedEventTypes.retainAll(filterEventTypes);
            }
            allAllowedEventTypes.addAll(allowedEventTypes);
            if (allowedEventTypes.size() <= 0) continue;
            ActivityTypeExpression activityTypeExpr = new ActivityTypeExpression(Expression.Operator.EQ, allowedEventTypes.toArray(new String[allowedEventTypes.size()]));
            StringExpression projectExpr = new StringExpression("projectName", Expression.Operator.EQ, projectName);
            exprs.add((Object)new AndExpression(new Expression[]{activityTypeExpr, projectExpr}));
        }
        if (!exprs.isEmpty()) {
            AndExpression finalExpr = new AndExpression(new Expression[0]);
            finalExpr.add((Object)exprs);
            if (untilDate != null) {
                finalExpr.add((Object)new DateExpression("date", Expression.Operator.LT, untilDate));
            }
            if (fromDate != null) {
                finalExpr.add((Object)new DateExpression("date", Expression.Operator.GT, fromDate));
            }
            if (StringUtils.isNotEmpty((CharSequence)pattern)) {
                OrExpression patternExprs = new OrExpression(new Expression[0]);
                patternExprs.add((Object)new StringExpression("projectTitle", Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true)));
                for (String allowedEventType : allAllowedEventTypes) {
                    this._activityTypeExtensionPoint.getActivityTypes(allowedEventType).stream().filter(AbstractWorkspacesActivityType.class::isInstance).map(AbstractWorkspacesActivityType.class::cast).forEach(wsActivityType -> {
                        Expression patternExpr = wsActivityType.getFilterPatternExpression(pattern);
                        if (patternExpr != null) {
                            patternExprs.add((Object)patternExpr);
                        }
                    });
                }
                finalExpr.add((Object)patternExprs);
            }
            String xpathQuery = ActivityHelper.getActivityXPathQuery((Expression)finalExpr);
            return this._resolver.query(xpathQuery);
        }
        return null;
    }

    public ZonedDateTime getDateOfLastActivity(String projectName, List<String> excludeActivityTypes) {
        AndExpression expressions = new AndExpression(new Expression[0]);
        for (String eventType : excludeActivityTypes) {
            expressions.add((Object)new ActivityTypeExpression(Expression.Operator.NE, eventType));
        }
        return this._getDateOfLastActivity(projectName, (Expression)expressions);
    }

    public ZonedDateTime getDateOfLastActivityByActivityType(String projectName, Collection<String> includeActivityTypes) {
        OrExpression expressions = new OrExpression(new Expression[0]);
        for (String eventType : includeActivityTypes) {
            expressions.add((Object)new ActivityTypeExpression(Expression.Operator.EQ, eventType));
        }
        return this._getDateOfLastActivity(projectName, (Expression)expressions);
    }

    private ZonedDateTime _getDateOfLastActivity(String projectName, Expression eventTypesExpression) {
        StringExpression projectNameExpression = new StringExpression("projectName", Expression.Operator.EQ, projectName);
        AndExpression eventExpr = new AndExpression(new Expression[]{projectNameExpression, eventTypesExpression});
        String xpathQuery = ActivityHelper.getActivityXPathQuery((Expression)eventExpr);
        AmetysObjectIterable activities = this._resolver.query(xpathQuery);
        AmetysObjectIterator ametysObjectIterator = activities.iterator();
        if (ametysObjectIterator.hasNext()) {
            Activity activity = (Activity)ametysObjectIterator.next();
            return activity.getDate();
        }
        return null;
    }

    public Set<String> getAllowedEventTypes(Set<Project> projects) {
        HashSet<String> allowedTypes = new HashSet<String>();
        for (Project project : projects) {
            allowedTypes.addAll(this._getAllowedEventTypesByProject(project));
        }
        return allowedTypes;
    }

    private Set<String> _getAllowedEventTypesByProject(Project project) {
        HashSet<String> allowedTypes = new HashSet<String>();
        for (WorkspaceModule moduleManager : this._projectManager.getModules(project)) {
            ModifiableResourceCollection moduleRoot = moduleManager.getModuleRoot(project, false);
            if (moduleRoot == null || !this._rightManager.currentUserHasReadAccess((Object)moduleRoot)) continue;
            allowedTypes.addAll(moduleManager.getAllowedEventTypes());
        }
        return allowedTypes;
    }

    @Callable(rights={"*"})
    public long getNumberOfUnreadActivitiesForCurrentUser() {
        Set<Project> userProjects = this._getProjectsForCurrentUser(null);
        List<String> projectNames = this._transformProjectsToName(userProjects);
        boolean neverReadEvents = true;
        long acc = 0L;
        for (String projectName : projectNames) {
            long nbUnread = this.getNumberOfUnreadActivitiesForCurrentUser(projectName);
            if (nbUnread == -1L) continue;
            acc += nbUnread;
            neverReadEvents = false;
        }
        return neverReadEvents ? -1L : acc;
    }

    @Callable(rights={"*"})
    public long getNumberOfUnreadActivitiesForCurrentUser(String projectName) {
        ZonedDateTime lastUpdate = this._getLastReadDate(projectName);
        if (lastUpdate != null) {
            Project project = this._projectManager.getProject(projectName);
            Set<String> allowedEventTypes = this.getAllowedEventTypes(Set.of(project));
            AmetysObjectIterable<Activity> activities = this._getActivities(Collections.singletonList(projectName), new ArrayList<String>(allowedEventTypes), lastUpdate, null, null);
            return activities != null ? activities.getSize() : -1L;
        }
        return -1L;
    }

    public List<Map<String, Object>> getActivitiesForCurrentUser(int limit) {
        return this.getActivitiesForCurrentUser(null, null, null, limit);
    }

    public List<Map<String, Object>> getActivitiesForCurrentUser(String pattern, Set<String> categories, Set<String> activityTypes, int limit) {
        return this.getActivitiesForCurrentUser(pattern, categories, activityTypes, null, null, limit);
    }

    public List<Map<String, Object>> getActivitiesForCurrentUser(String pattern, Set<String> categories, Set<String> activityTypes, ZonedDateTime fromDate, ZonedDateTime untilDate, int limit) {
        return this.getActivitiesForCurrentUser(pattern, null, categories, activityTypes, fromDate, untilDate, limit);
    }

    public List<Map<String, Object>> getActivitiesForCurrentUser(String pattern, Set<String> projectNames, Set<String> categories, Set<String> activityTypes, ZonedDateTime fromDate, ZonedDateTime untilDate, int limit) {
        Set<Project> userProjects = this._getProjectsForCurrentUser(categories);
        if (projectNames != null && !projectNames.isEmpty()) {
            userProjects = userProjects.stream().filter(p -> projectNames.contains(p.getName())).collect(Collectors.toSet());
        }
        return this.getActivitiesForCurrentUser(userProjects, activityTypes, fromDate, untilDate, pattern, limit);
    }

    public List<Map<String, Object>> getActivitiesForCurrentUser(Set<Project> projects, Set<String> activityTypes, ZonedDateTime fromDate, ZonedDateTime untilDate, String pattern, int limit) {
        List<String> projectNames = this._transformProjectsToName(projects);
        Set<String> allowedActivityTypes = this.getAllowedEventTypes(projects);
        if (activityTypes != null && activityTypes.size() > 0) {
            allowedActivityTypes.retainAll(activityTypes);
        }
        List<Map<String, Object>> activities = this.getActivities(projectNames, new ArrayList<String>(allowedActivityTypes), fromDate, untilDate, pattern, limit);
        activities.stream().forEach(activity -> {
            String eventDate = (String)activity.get("date");
            String projectName = (String)activity.get("projectName");
            ZonedDateTime lastReadDate = this._getLastReadDate(projectName);
            if (lastReadDate != null) {
                activity.put("unread", DateUtils.parseZonedDateTime((String)eventDate).compareTo(lastReadDate) > 0);
            }
            activity.put("date-iso", eventDate);
            String endDate = (String)activity.get("endDate");
            if (endDate != null) {
                activity.put("end-date-iso", endDate);
            }
        });
        return activities;
    }

    private ZonedDateTime _getLastReadDate(String projectName) {
        UserIdentity user = this._currentUserProvider.getUser();
        try {
            ZonedDateTime projectLastReadDate = null;
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{projectName})) {
                projectLastReadDate = this._userPrefManager.getUserPreferenceAsDate(user, "/workspaces/activity-stream/" + projectName, Map.of(), ACTIVITY_STREAM_USER_PREF_LAST_UPDATE);
            }
            ZonedDateTime globalLastReadDate = this._userPrefManager.getUserPreferenceAsDate(user, ACTIVITY_STREAM_USER_PREF_CONTEXT, Map.of(), ACTIVITY_STREAM_USER_PREF_LAST_UPDATE);
            return projectLastReadDate != null ? (globalLastReadDate != null && globalLastReadDate.isAfter(projectLastReadDate) ? globalLastReadDate : projectLastReadDate) : globalLastReadDate;
        }
        catch (UserPreferencesException e) {
            this.getLogger().warn("Unable to get last unread events date from user preferences", (Throwable)e);
            return null;
        }
    }

    private Set<Project> _getProjectsForCurrentUser(Set<String> filteredCategories) {
        UserIdentity user = this._currentUserProvider.getUser();
        Predicate<Project> matchCategories = p -> filteredCategories == null || filteredCategories.isEmpty() || !Collections.disjoint(p.getCategories(), filteredCategories);
        return this._projectManager.getUserProjects(user).keySet().stream().filter(matchCategories).collect(Collectors.toSet());
    }

    private List<String> _transformProjectsToName(Set<Project> userProjects) {
        return userProjects.stream().map(p -> p.getName()).collect(Collectors.toList());
    }
}

