/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.activitystream;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.workspaces.activities.activitystream.ActivityStreamClientInteraction;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class ActivityStreamServiceComponent
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = ActivityStreamServiceComponent.class.getName();
    private ActivityStreamClientInteraction _activityStream;
    private ProjectManager _projectManager;
    private UserPreferencesManager _userPrefManager;
    private CurrentUserProvider _currentUserProvider;
    private WorkspaceModuleExtensionPoint _moduleEP;
    private Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._activityStream = (ActivityStreamClientInteraction)((Object)manager.lookup(ActivityStreamClientInteraction.ROLE));
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._userPrefManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public Map<String, Object> getActivityStream(int limit, boolean allActivities, boolean markAsRead) throws UserPreferencesException {
        String siteName;
        List<String> currentProjectNames;
        Request request = ContextHelper.getRequest((Context)this._context);
        Set<String> activityTypes = this._getFilteredActivityTypes(request);
        Set<String> categories = this._getFilteredCategories(request);
        Set<String> projects = this._getFilteredProjects(request);
        String pattern = request.getParameter("pattern");
        ZonedDateTime fromDate = null;
        String fromDateAsStr = request.getParameter("fromDate");
        if (StringUtils.isNotEmpty((CharSequence)fromDateAsStr)) {
            fromDate = DateUtils.parseZonedDateTime((String)fromDateAsStr);
        }
        ZonedDateTime untilDate = null;
        String untilDateAsStr = request.getParameter("untilDate");
        if (StringUtils.isNotEmpty((CharSequence)untilDateAsStr)) {
            untilDate = DateUtils.parseZonedDateTime((String)untilDateAsStr);
        }
        Project currentProject = !(currentProjectNames = this._projectManager.getProjectsForSite(siteName = WebHelper.getSiteName((Request)request))).isEmpty() ? this._projectManager.getProject(currentProjectNames.get(0)) : null;
        List<Map<String, Object>> activities = currentProject == null || allActivities ? this._activityStream.getActivitiesForCurrentUser(pattern, projects, categories, activityTypes, fromDate, untilDate, limit) : this._activityStream.getActivitiesForCurrentUser(Collections.singleton(currentProject), activityTypes, fromDate, untilDate, pattern, limit);
        UserIdentity user = this._currentUserProvider.getUser();
        if (markAsRead && user != null) {
            Object userPrefContext = "/workspaces/activity-stream";
            if (currentProject != null && !allActivities) {
                userPrefContext = (String)userPrefContext + "/" + currentProject.getName();
            }
            this._userPrefManager.setUserPreferences(user, (String)userPrefContext, Map.of(), Map.of("lastUpdate", DateUtils.dateToString((Date)new Date())));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("events", activities);
        return result;
    }

    private Set<String> _getFilteredActivityTypes(Request request) {
        String[] moduleIds = request.getParameterValues("modules");
        if (moduleIds != null) {
            return Arrays.stream(moduleIds).filter(StringUtils::isNotEmpty).map(id -> this._moduleEP.getModule((String)id)).map(WorkspaceModule::getAllowedEventTypes).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private Set<String> _getFilteredCategories(Request request) {
        String[] categoryIds = request.getParameterValues("categories");
        if (categoryIds != null) {
            return Arrays.stream(categoryIds).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        }
        return Set.of();
    }

    private Set<String> _getFilteredProjects(Request request) {
        String[] projectIds = request.getParameterValues("projects");
        if (projectIds != null) {
            return Arrays.stream(projectIds).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        }
        return Set.of();
    }
}

