/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.activitystream;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryHelper;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WorkspacesServiceGenerator
extends ServiceableGenerator {
    private ProjectManager _projectManager;
    private CategoryHelper _categoryHelper;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(this.manager);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._categoryHelper = (CategoryHelper)smanager.lookup(CategoryHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        boolean saxModules;
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Workspaces");
        UserIdentity user = this._currentUserProvider.getUser();
        boolean saxCategories = this.parameters.getParameterAsBoolean("saxCategories", false);
        if (saxCategories) {
            this._saxCategories(user);
        }
        if (saxModules = this.parameters.getParameterAsBoolean("saxModules", false)) {
            this._saxModules(user);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Workspaces");
        this.contentHandler.endDocument();
    }

    private void _saxCategories(UserIdentity user) throws SAXException {
        Set<Category> categories = this._projectManager.getUserProjectsCategories(user);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"categories");
        for (Category category : categories) {
            this._saxCategory(category);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"categories");
    }

    private void _saxCategory(Category category) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", category.getId());
        attrs.addCDATAAttribute("name", category.getName());
        attrs.addCDATAAttribute("color", this._categoryHelper.getCategoryColor(category).get("main"));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"category", (Attributes)attrs);
        category.getTitle().toSAX(this.contentHandler);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"category");
    }

    private void _saxModules(UserIdentity user) throws SAXException {
        Set modulesWithActivities = this._projectManager.getUserProjectsModules(user).stream().filter(m -> !m.getAllowedEventTypes().isEmpty()).collect(Collectors.toSet());
        for (WorkspaceModule module : modulesWithActivities) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"modules");
            this._saxModule(module);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"modules");
        }
    }

    private void _saxModule(WorkspaceModule module) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", module.getId());
        attrs.addCDATAAttribute("name", module.getModuleName());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"module", (Attributes)attrs);
        module.getModuleTitle().toSAX(this.contentHandler);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"module");
    }
}

