/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars;

import com.google.common.collect.ImmutableSet;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.DateExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarDAO;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventJSONHelper;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventOccurrence;
import org.ametys.plugins.workspaces.calendars.task.TaskCalendar;
import org.ametys.plugins.workspaces.calendars.task.TaskCalendarEvent;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections.ListUtils;

public class CalendarWorkspaceModule
extends AbstractWorkspaceModule
implements Configurable {
    public static final String CALENDAR_MODULE_ID = CalendarWorkspaceModule.class.getName();
    private static final String __WORKSPACES_CALENDARS_NODE_NAME = "calendars";
    private static final String __WORKSPACES_CALENDARS_ROOT_NODE_NAME = "calendars-root";
    private static final String __WORKSPACES_CALENDAR_RESOURCES_ROOT_NODE_NAME = "calendar-resources-root";
    private static final String __WORKSPACES_RESOURCE_CALENDAR_ROOT_NODE_NAME = "resource-calendar-root";
    private static final String __CALENDAR_CACHE_REQUEST_ATTR = CalendarWorkspaceModule.class.getName() + "$calendarCache";
    private static final String __EVENT_NUMBER_HEADER_ID = "calendars$event_number";
    protected WorkspacesHelper _workspaceHelper;
    private CalendarDAO _calendarDAO;
    private CalendarEventJSONHelper _calendarEventJSONHelper;
    private I18nizableText _defaultCalendarTemplateDesc;
    private String _defaultCalendarColor;
    private String _defaultCalendarVisibility;
    private String _defaultCalendarWorkflowName;
    private I18nizableText _defaultCalendarTitle;
    private I18nizableText _defaultCalendarDescription;
    private I18nizableText _resourceCalendarTemplateDesc;
    private String _resourceCalendarColor;
    private String _resourceCalendarVisibility;
    private String _resourceCalendarWorkflowName;
    private I18nizableText _resourceCalendarTitle;
    private I18nizableText _resourceCalendarDescription;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._calendarDAO = (CalendarDAO)((Object)manager.lookup(CalendarDAO.ROLE));
        this._calendarEventJSONHelper = (CalendarEventJSONHelper)((Object)manager.lookup(CalendarEventJSONHelper.ROLE));
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._defaultCalendarTemplateDesc = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("template-desc"), (String)("plugin." + this._pluginName), (String)"");
        this._defaultCalendarColor = configuration.getChild("color").getValue("col1");
        this._defaultCalendarVisibility = configuration.getChild("visibility").getValue(Calendar.CalendarVisibility.PRIVATE.name());
        this._defaultCalendarWorkflowName = configuration.getChild("workflow").getValue("calendar-default");
        this._defaultCalendarTitle = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("title"), (String)("plugin." + this._pluginName));
        this._defaultCalendarDescription = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("description"), (String)("plugin." + this._pluginName), (String)"");
        this._resourceCalendarTemplateDesc = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("resource-template-desc"), (String)("plugin." + this._pluginName), (String)"");
        this._resourceCalendarColor = configuration.getChild("resource-color").getValue("resourcecol0");
        this._resourceCalendarVisibility = configuration.getChild("resource-visibility").getValue(Calendar.CalendarVisibility.PRIVATE.name());
        this._resourceCalendarWorkflowName = configuration.getChild("resource-workflow").getValue("calendar-default");
        this._resourceCalendarTitle = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("resource-title"), (String)("plugin." + this._pluginName));
        this._resourceCalendarDescription = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("resource-description"), (String)("plugin." + this._pluginName), (String)"");
    }

    @Override
    public String getId() {
        return CALENDAR_MODULE_ID;
    }

    @Override
    public int getOrder() {
        return 40;
    }

    @Override
    public String getModuleName() {
        return __WORKSPACES_CALENDARS_NODE_NAME;
    }

    @Override
    protected String getModulePageName() {
        return __WORKSPACES_CALENDARS_NODE_NAME;
    }

    @Override
    public I18nizableText getModuleTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_CALENDAR_LABEL");
    }

    @Override
    public I18nizableText getModuleDescription() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_CALENDAR_DESCRIPTION");
    }

    @Override
    protected I18nizableText getModulePageTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_CALENDARS_TITLE");
    }

    @Override
    protected void initializeModulePage(ModifiablePage calendarPage) {
        ModifiableZone defaultZone = calendarPage.createZone("default");
        String serviceId = "org.ametys.plugins.workspaces.module.Calendar";
        ModifiableZoneItem defaultZoneItem = defaultZone.addZoneItem();
        defaultZoneItem.setType(ZoneItem.ZoneType.SERVICE);
        defaultZoneItem.setServiceId(serviceId);
        ModifiableModelAwareDataHolder serviceDataHolder = defaultZoneItem.getServiceParameters();
        serviceDataHolder.setValue("xslt", (Object)this._getDefaultXslt(serviceId));
    }

    public List<Calendar> getCalendars(Project project, boolean withTaskCalendar) {
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        ModifiableResourceCollection calendarRoot = this.getCalendarsRoot(project, false);
        if (calendarRoot != null) {
            TaskCalendar taskCalendar;
            calendarRoot.getChildren().stream().filter(Calendar.class::isInstance).map(Calendar.class::cast).forEach(calendars::add);
            if (withTaskCalendar && (taskCalendar = this._calendarDAO.getTaskCalendar(project, false)) != null) {
                calendars.add(taskCalendar);
            }
        }
        return calendars;
    }

    public String getEventUri(Project project, String calendarId, String eventId) {
        String moduleUrl = this.getModuleUrl(project);
        if (moduleUrl != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(moduleUrl);
            try {
                CalendarEvent event = (CalendarEvent)this._resolver.resolveById(eventId);
                if (event.getStartDate() != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    sb.append("?date=").append(df.format(DateUtils.asDate((ZonedDateTime)event.getStartDate())));
                }
            }
            catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                // empty catch block
            }
            sb.append("#").append(calendarId);
            return sb.toString();
        }
        return null;
    }

    protected void _addAdditionalEventData(CalendarEvent event, Map<String, Object> eventData) {
        Map calendarCache;
        Request request = ContextHelper.getRequest((Context)this._context);
        Calendar calendar = event.getCalendar();
        Project project = calendar.getProject();
        if (request.getAttribute(__CALENDAR_CACHE_REQUEST_ATTR) == null) {
            request.setAttribute(__CALENDAR_CACHE_REQUEST_ATTR, new HashMap());
        }
        if (!(calendarCache = (Map)request.getAttribute(__CALENDAR_CACHE_REQUEST_ATTR)).containsKey(calendar.getId())) {
            HashMap<String, Object> calendarInfo = new HashMap<String, Object>();
            calendarInfo.put("calendarName", calendar.getName());
            calendarInfo.put("calendarIsPublic", Calendar.CalendarVisibility.PUBLIC.equals((Object)calendar.getVisibility()));
            calendarInfo.put("calendarHasViewRight", this.canView(calendar));
            calendarInfo.put("projectId", project.getId());
            calendarInfo.put("projectTitle", project.getTitle());
            Set<Page> calendarModulePages = this._projectManager.getModulePages(project, this);
            if (!calendarModulePages.isEmpty()) {
                Page calendarModulePage = calendarModulePages.iterator().next();
                calendarInfo.put("calendarModulePageId", calendarModulePage.getId());
            }
            calendarCache.put(calendar.getId(), calendarInfo);
        }
        eventData.putAll((Map)calendarCache.get(calendar.getId()));
        eventData.put("eventUrl", this.getEventUri(project, calendar.getId(), event.getId()));
    }

    public List<Map<String, Object>> getUpcomingEvents(int months, int maxResults, List<String> calendarIds, List<String> tagIds) {
        ArrayList<Map<String, Object>> basicEventList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> recurrentEventList = new ArrayList<Map<String, Object>>();
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ZonedDateTime startDate = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS);
        ZonedDateTime endDate = startDate.plusMonths(months);
        StringExpression nonRecurrentExpr = new StringExpression("recurrenceType", Expression.Operator.EQ, "NEVER");
        DateExpression startDateExpr = new DateExpression("startDate", Expression.Operator.GE, startDate);
        DateExpression endDateExpr = new DateExpression("startDate", Expression.Operator.LE, endDate);
        OrExpression keywordsExpr = null;
        if (tagIds != null && !tagIds.isEmpty()) {
            ArrayList<StringExpression> orExpr = new ArrayList<StringExpression>();
            for (String tagId : tagIds) {
                orExpr.add(new StringExpression("keywords", Expression.Operator.EQ, tagId));
            }
            keywordsExpr = new OrExpression(orExpr.toArray(new Expression[orExpr.size()]));
        }
        AndExpression eventExpr = new AndExpression(new Expression[]{nonRecurrentExpr, startDateExpr, endDateExpr, keywordsExpr});
        SortCriteria sortCriteria = new SortCriteria();
        sortCriteria.addCriterion("startDate", true, false);
        String basicEventQuery = QueryHelper.getXPathQuery(null, (String)"ametys:calendar-event", (Expression)eventExpr, (SortCriteria)sortCriteria);
        AmetysObjectIterable basicEvents = this._resolver.query(basicEventQuery);
        AmetysObjectIterator basicEventIt = basicEvents.iterator();
        int processed = 0;
        while (basicEventIt.hasNext() && processed < maxResults) {
            CalendarEvent event = (CalendarEvent)basicEventIt.next();
            Calendar holdingCalendar = event.getCalendar();
            if (!this._filterEvent(calendarIds, event) || !this._hasAccess(holdingCalendar)) continue;
            Map<String, Object> eventData = this._calendarEventJSONHelper.eventAsJson(event, false, false);
            basicEventList.add(eventData);
            ++processed;
            this._addAdditionalEventData(event, eventData);
        }
        StringExpression recurrentExpr = new StringExpression("recurrenceType", Expression.Operator.NE, "NEVER");
        eventExpr = new AndExpression(new Expression[]{recurrentExpr, keywordsExpr});
        String recurrentEventQuery = QueryHelper.getXPathQuery(null, (String)"ametys:calendar-event", (Expression)eventExpr, (SortCriteria)sortCriteria);
        AmetysObjectIterable recurrentEvents = this._resolver.query(recurrentEventQuery);
        AmetysObjectIterator recurrentEventIt = recurrentEvents.iterator();
        processed = 0;
        while (recurrentEventIt.hasNext()) {
            CalendarEvent event = (CalendarEvent)recurrentEventIt.next();
            Optional<CalendarEventOccurrence> nextOccurrence = event.getNextOccurrence(new CalendarEventOccurrence(event, startDate));
            if (!nextOccurrence.isPresent() || !nextOccurrence.get().before(endDate)) continue;
            List<CalendarEventOccurrence> occurrences = event.getOccurrences(nextOccurrence.get().getStartDate(), endDate);
            Calendar holdingCalendar = event.getCalendar();
            if (!this._filterEvent(calendarIds, event) || !this._hasAccess(holdingCalendar)) continue;
            for (CalendarEventOccurrence occurrence : occurrences) {
                Map<String, Object> eventData = this._calendarEventJSONHelper.eventAsJsonWithOccurrence(event, occurrence.getStartDate(), false);
                recurrentEventList.add(eventData);
                ++processed;
                this._addAdditionalEventData(event, eventData);
            }
        }
        List allEvents = ListUtils.union(basicEventList, recurrentEventList);
        Collections.sort(allEvents, new StartDateComparator());
        return allEvents.size() <= maxResults ? allEvents : allEvents.subList(0, maxResults);
    }

    private boolean _filterEvent(List<String> calendarIds, CalendarEvent event) {
        Calendar holdingCalendar = event.getCalendar();
        return calendarIds == null || calendarIds.get(0) == null || calendarIds.contains(holdingCalendar.getId());
    }

    private boolean _hasAccess(Calendar calendar) {
        return Calendar.CalendarVisibility.PUBLIC.equals((Object)calendar.getVisibility()) || this.canView(calendar);
    }

    public boolean canView(Calendar calendar) {
        if (calendar instanceof TaskCalendar) {
            return this._calendarDAO.hasTaskCalendarReadAccess(calendar.getProject());
        }
        return this._rightManager.currentUserHasReadAccess((Object)calendar);
    }

    public boolean canView(CalendarEvent event) {
        if (event instanceof TaskCalendarEvent) {
            TaskCalendarEvent taskEvent = (TaskCalendarEvent)event;
            return this._rightManager.currentUserHasReadAccess((Object)taskEvent.getTask());
        }
        return this._rightManager.currentUserHasReadAccess((Object)event.getCalendar());
    }

    @Override
    public Set<String> getAllowedEventTypes() {
        return ImmutableSet.of((Object)"calendar.event.created", (Object)"calendar.event.updated", (Object)"calendar.event.deleting");
    }

    @Override
    protected void _internalActivateModule(Project project, Map<String, Object> additionalValues) {
        this.createResourceCalendar(project, additionalValues);
        this._createDefaultCalendar(project, additionalValues);
    }

    public Calendar createResourceCalendar(Project project, Map<String, Object> additionalValues) {
        ModifiableResourceCollection resourceCalendarRoot = this.getResourceCalendarRoot(project, true);
        String lang = additionalValues.containsKey("language") ? (String)additionalValues.get("language") : this._workspaceHelper.getLang(project);
        Calendar resourceCalendar = resourceCalendarRoot.getChildren().stream().filter(Calendar.class::isInstance).map(Calendar.class::cast).findFirst().orElse(null);
        if (resourceCalendar == null) {
            Boolean renameIfExists = false;
            Boolean checkRights = false;
            String description = this._i18nUtils.translate((I18nizable)this._resourceCalendarDescription, lang);
            String inputName = this._i18nUtils.translate((I18nizable)this._resourceCalendarTitle, lang);
            String templateDesc = this._i18nUtils.translate((I18nizable)this._resourceCalendarTemplateDesc, lang);
            try {
                Map<String, Object> result = this._calendarDAO.addCalendar((ModifiableTraversableAmetysObject)resourceCalendarRoot, inputName, description, templateDesc, this._resourceCalendarColor, this._resourceCalendarVisibility, this._resourceCalendarWorkflowName, renameIfExists, checkRights, false);
                resourceCalendar = (Calendar)this._resolver.resolveById((String)result.get("id"));
            }
            catch (Exception e) {
                this.getLogger().error("Error while trying to create the first calendar in a newly created project", (Throwable)e);
            }
        }
        return resourceCalendar;
    }

    private void _createDefaultCalendar(Project project, Map<String, Object> additionalValues) {
        ModifiableResourceCollection moduleRoot = this.getCalendarsRoot(project, true);
        if (moduleRoot != null && !this._hasOtherCalendar(project)) {
            Boolean renameIfExists = false;
            Boolean checkRights = false;
            String lang = additionalValues.containsKey("language") ? (String)additionalValues.get("language") : this._workspaceHelper.getLang(project);
            String description = this._i18nUtils.translate((I18nizable)this._defaultCalendarDescription, lang);
            String inputName = this._i18nUtils.translate((I18nizable)this._defaultCalendarTitle, lang);
            String templateDesc = this._i18nUtils.translate((I18nizable)this._defaultCalendarTemplateDesc, lang);
            try {
                this._calendarDAO.addCalendar((ModifiableTraversableAmetysObject)moduleRoot, inputName, description, templateDesc, this._defaultCalendarColor, this._defaultCalendarVisibility, this._defaultCalendarWorkflowName, renameIfExists, checkRights, false);
            }
            catch (Exception e) {
                this.getLogger().error("Error while trying to create the first calendar in a newly created project", (Throwable)e);
            }
        }
    }

    private boolean _hasOtherCalendar(Project project) {
        List<Calendar> calendars = this.getCalendars(project, false);
        return calendars.size() > 0;
    }

    public Calendar getResourceCalendar(Project project) {
        ModifiableResourceCollection resourceCalendarRoot = this.getResourceCalendarRoot(project, true);
        return resourceCalendarRoot.getChildren().stream().filter(Calendar.class::isInstance).map(Calendar.class::cast).findFirst().orElse(this.createResourceCalendar(project, new HashMap<String, Object>()));
    }

    public ModifiableResourceCollection getCalendarResourcesRoot(Project project, boolean create) {
        ModifiableResourceCollection moduleRoot = this.getModuleRoot(project, create);
        return (ModifiableResourceCollection)this._getAmetysObject((ModifiableTraversableAmetysObject)moduleRoot, __WORKSPACES_CALENDAR_RESOURCES_ROOT_NODE_NAME, "ametys:resources-collection", create);
    }

    public ModifiableResourceCollection getCalendarsRoot(Project project, boolean create) {
        ModifiableResourceCollection moduleRoot = this.getModuleRoot(project, create);
        return (ModifiableResourceCollection)this._getAmetysObject((ModifiableTraversableAmetysObject)moduleRoot, __WORKSPACES_CALENDARS_ROOT_NODE_NAME, "ametys:resources-collection", create);
    }

    public ModifiableResourceCollection getResourceCalendarRoot(Project project, boolean create) {
        ModifiableResourceCollection moduleRoot = this.getModuleRoot(project, create);
        return (ModifiableResourceCollection)this._getAmetysObject((ModifiableTraversableAmetysObject)moduleRoot, __WORKSPACES_RESOURCE_CALENDAR_ROOT_NODE_NAME, "ametys:resources-collection", create);
    }

    @Override
    public Map<String, Object> _getInternalStatistics(Project project, boolean isActive) {
        if (isActive) {
            List<Calendar> calendars = this.getCalendars(project, true);
            Calendar ressourceCalendar = this.getResourceCalendar(project);
            long eventNumber = Stream.concat(calendars.stream(), Stream.of(ressourceCalendar)).map(Calendar::getAllEvents).flatMap(Collection::stream).count();
            return Map.of(__EVENT_NUMBER_HEADER_ID, eventNumber);
        }
        return Map.of(__EVENT_NUMBER_HEADER_ID, __SIZE_INACTIVE);
    }

    @Override
    public List<StatisticColumn> _getInternalStatisticModel() {
        return List.of(new StatisticColumn(__EVENT_NUMBER_HEADER_ID, new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_EVENT_NUMBER")).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderElements").withType(StatisticsColumnType.LONG).withGroup("general$elements"));
    }

    @Override
    public Set<String> getAllEventTypes() {
        return Set.of("calendar.created", "calendar.deleted", "calendar.event.created", "calendar.event.deleting", "calendar.event.updated", "calendar.moved", "calendar.resource.created", "calendar.resource.deleted", "calendar.resource.updated", "calendar.updated");
    }

    protected static class StartDateComparator
    implements Comparator<Map<String, Object>> {
        protected StartDateComparator() {
        }

        @Override
        public int compare(Map<String, Object> calendarEventInfo1, Map<String, Object> calendarEventInfo2) {
            String startDate1asString = (String)calendarEventInfo1.get("startDate");
            String startDate2asString = (String)calendarEventInfo2.get("startDate");
            Date startDate1 = DateUtils.parse((String)startDate1asString);
            Date startDate2 = DateUtils.parse((String)startDate2asString);
            return startDate1.compareTo(startDate2);
        }
    }
}

