/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.comments;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.mentions.AbstractNotifyMentionsObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.json.ThreadJSONHelper;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class NotifyThreadMentionsObserver
extends AbstractNotifyMentionsObserver<Thread>
implements Contextualizable {
    protected RightManager _rightManager;
    protected ForumWorkspaceModule _forumModule;
    protected ProjectManager _projectManager;
    protected ThreadJSONHelper _threadJSONHelper;
    protected Context _context;
    protected WorkspacesHelper _workspaceHelper;
    protected ProjectRightHelper _projectRightsHelper;
    protected RenderingContextHandler _renderingContextHandler;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._forumModule = (ForumWorkspaceModule)moduleManagerEP.getModule(ForumWorkspaceModule.FORUM_MODULE_ID);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._threadJSONHelper = (ThreadJSONHelper)((Object)manager.lookup(ThreadJSONHelper.ROLE));
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._projectRightsHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Map arguments = event.getArguments();
        Thread thread = (Thread)arguments.get("forumthreadthread");
        Project project = this._projectManager.getParentProject((AmetysObject)thread);
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute("site", (Object)project.getName());
        super.observe(event, transientVars);
    }

    public boolean supports(Event event) {
        return event.getId().equals("forumthread.created");
    }

    protected I18nizableText _getMailTitle(AbstractNotifyMentionsObserver.MentionableObject mentionableObject) {
        Thread thread = (Thread)mentionableObject.ametysObject();
        Project project = this._projectManager.getParentProject((AmetysObject)thread);
        List<String> i18nParams = List.of(project.getTitle());
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_WORKSPACES_MENTION_MAIL_SUBJECT", i18nParams);
    }

    protected I18nizableText _getMailSubject(AbstractNotifyMentionsObserver.MentionableObject mentionableObject) {
        Project project = this._projectManager.getParentProject(mentionableObject.ametysObject());
        List<String> i18nParams = List.of(project.getTitle());
        return new I18nizableText("plugin.cms", "PLUGINS_CMS_AMETYS_OBJECT_THREAD_MENTION_MAIL_SUBJECT", i18nParams);
    }

    protected AbstractNotifyMentionsObserver.MentionableObject _getMentionableObjectFromArguments(Map<String, Object> arguments) throws Exception {
        Thread thread = (Thread)arguments.get("forumthreadthread");
        thread = (Thread)this._resolver.resolveById(thread.getId());
        Project project = this._projectManager.getParentProject((AmetysObject)thread);
        String content = this._getContentFromThread(thread);
        String url = this._getUrl(thread, project);
        return new AbstractNotifyMentionsObserver.MentionableObject(this._userManager.getUser(thread.getAuthor()), content, (Collection)this._mentionUtils.extractMentionedUsersFromRichText(content), thread.getCreationDate(), (AmetysObject)thread, new AbstractNotifyMentionsObserver.LinkToAmetysObject(url, new I18nizableText("plugin.workspaces", "PROJECT_MAIL_NOTIFICATION_BODY_FORUMTHREAD_BUTTON_TEXT")), this._workspaceHelper.getLang(project));
    }

    private String _getContentFromThread(Thread thread) throws IOException {
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = (String)request.getAttribute("site");
        Project project = this._projectManager.getParentProject((AmetysObject)thread);
        if (siteName == null) {
            request.setAttribute("site", (Object)project.getSite().getName());
        }
        return this._threadJSONHelper.richTextToRendering(thread.getContent());
    }

    private String _getAmetysObjectTitle(Thread thread) {
        return thread.getTitle();
    }

    protected String _transformSyntaxTextToReadableTextWithColors(String content, UserIdentity recipient) {
        return this._mentionUtils.transformRichTextToReadableText(content, recipient);
    }

    protected I18nizableText _getMailMessageType() {
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_THREAD_MENTION_MAIL_DESCRIPTION_TITLE");
    }

    protected I18nizableText _getMailMessage(AbstractNotifyMentionsObserver.MentionableObject mentionableObject) {
        Thread thread = (Thread)mentionableObject.ametysObject();
        Project project = this._projectManager.getParentProject((AmetysObject)thread);
        User author = mentionableObject.author();
        List<String> i18nParams = List.of(author.getFullName(), this._getAmetysObjectTitle(thread), project.getTitle());
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_THREAD_MENTION_MAIL_MESSAGE", i18nParams);
    }

    protected boolean _canSendMailToMentionedUser(Thread thread, User authorIdentity, UserIdentity mentionedUserIdentity) {
        Project project = this._projectManager.getParentProject((AmetysObject)thread);
        return super._canSendMailToMentionedUser((AmetysObject)thread, authorIdentity, mentionedUserIdentity) && this._projectRightsHelper.hasReadAccessOnModule(project, ForumWorkspaceModule.FORUM_MODULE_ID, mentionedUserIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getUrl(Thread thread, Project project) {
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute("forceAbsoluteUrl", (Object)true);
        RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
        this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
        try {
            String string = this._forumModule.getThreadUri(project, thread.getId());
            return string;
        }
        finally {
            this._renderingContextHandler.setRenderingContext(currentContext);
        }
    }
}

