/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.datapolicy;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.ametys.cms.repository.ReactionableObject;
import org.ametys.cms.repository.ReactionableObjectHelper;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.PersonalDataProcessingException;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractCommentAndReactionDataPolicy
extends AbstractLogEnabled
implements PersonalDataPolicy,
Serviceable {
    protected UserManager _userManager;
    protected Repository _repository;
    protected AmetysObjectResolver _resolver;
    private ModelItemTypeExtensionPoint _unversionedDataTypeExtensionPoint;
    private Period _retentionPeriod;

    public void service(ServiceManager manager) throws ServiceException {
        this._repository = (Repository)manager.lookup("javax.jcr.Repository");
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._unversionedDataTypeExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_UNVERSIONED);
        Long config = (Long)Config.getInstance().getValue("cms.comment.data.policy.retention.period", false, null);
        this._retentionPeriod = config != null && config >= 0L ? Period.ofMonths(config.intValue()) : null;
    }

    public PersonalDataPolicy.AnonymizationResult process(UserStatusInfo userStatusInfo) throws PersonalDataProcessingException {
        if (this._retentionPeriod == null || userStatusInfo.getMissingSinceDate().isAfter(ZonedDateTime.now().minus(this._retentionPeriod))) {
            return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
        }
        int handled = 0;
        boolean error = false;
        Session session = null;
        try {
            session = this._repository.login();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            HandlingResult result = this.handleComments(userStatusInfo, queryManager);
            handled += result.handled();
            PersonalDataPolicy.AnonymizationResult anonymizationResult = (error |= result.failed() > 0) ? PersonalDataPolicy.AnonymizationResult.ERROR : ((handled += this.handleCommentReactions(userStatusInfo, queryManager)) == 0 ? PersonalDataPolicy.AnonymizationResult.NO_DATA : PersonalDataPolicy.AnonymizationResult.PROCESSED);
            return anonymizationResult;
        }
        catch (RepositoryException e) {
            throw new PersonalDataProcessingException("An error prevented the processing of comment from '" + String.valueOf(userStatusInfo.getUserIdentity()) + "'.", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected HandlingResult handleComments(UserStatusInfo userStatusInfo, QueryManager queryManager) throws RepositoryException {
        int handled = 0;
        int failed = 0;
        String query = this.getCommentsQuery(userStatusInfo);
        QueryResult result = queryManager.createQuery(query.toString(), "xpath").execute();
        NodeIterator nodes = result.getNodes();
        while (nodes.hasNext()) {
            Node commentNode = nodes.nextNode();
            if (this.handleComment(commentNode)) {
                ++handled;
                continue;
            }
            ++failed;
        }
        if (handled > 0 || failed > 0) {
            ForensicLogger.info((String)("data.policy.gdpr.anonymize." + this.getLogCategory() + ".comments"), Map.of("handled", Long.toString(handled), "failed", Long.toString(failed), "identity", userStatusInfo.getUserIdentity()), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
        }
        return new HandlingResult(handled, failed);
    }

    protected abstract String getLogCategory();

    protected String getCommentsQuery(UserStatusInfo userStatusInfo) {
        StringBuilder query = new StringBuilder("//element(*, " + this.getObjectPrimaryType() + ")").append("//ametys:comments").append("/*[").append(new UserExpression("author", Expression.Operator.EQ, userStatusInfo.getUserIdentity()).build()).append("]");
        return query.toString();
    }

    protected abstract String getObjectPrimaryType();

    protected abstract boolean handleComment(Node var1);

    protected Pair<Node, String> getObjectNodeAndCommentId(Node commentNode) {
        String commentNodePath = null;
        try {
            Node parentNode;
            commentNodePath = commentNode.getPath();
            StringBuilder commentId = new StringBuilder(StringUtils.removeStart((String)commentNode.getName(), (String)"ametys:"));
            for (parentNode = commentNode.getParent(); parentNode != null && !this.getObjectPrimaryType().equals(parentNode.getPrimaryNodeType().getName()); parentNode = parentNode.getParent()) {
                if (!parentNode.getName().startsWith("ametys:comment-")) continue;
                commentId.insert(0, "_").insert(0, StringUtils.removeStart((String)parentNode.getName(), (String)"ametys:"));
            }
            if (parentNode == null) {
                this.getLogger().error("Parent holder object not found from comment node '{}'", (Object)commentNodePath);
                return null;
            }
            return Pair.of((Object)parentNode, (Object)commentId.toString());
        }
        catch (RepositoryException | AmetysRepositoryException e) {
            this.getLogger().error("Failed to retrieve parent holder and comment from comment node '{}'", (Object)commentNodePath, (Object)e);
            return null;
        }
    }

    protected int handleCommentReactions(UserStatusInfo userStatusInfo, QueryManager queryManager) throws RepositoryException {
        int handled = 0;
        for (ReactionableObject.ReactionType type : ReactionableObject.ReactionType.values()) {
            StringBuilder query = new StringBuilder("//element(*, " + this.getObjectPrimaryType() + ")/ametys:comments").append("//").append("ametys").append(":").append(type.name().toLowerCase()).append("[").append(new UserExpression("users", Expression.Operator.EQ, userStatusInfo.getUserIdentity(), true).build()).append("]");
            QueryResult result = queryManager.createQuery(query.toString(), "xpath").execute();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node parentNode = nodes.nextNode().getParent();
                JCRRepositoryData repositoryData = new JCRRepositoryData(parentNode);
                DefaultModifiableModelLessDataHolder reactionableObject = new DefaultModifiableModelLessDataHolder(this._unversionedDataTypeExtensionPoint, (ModifiableRepositoryData)repositoryData);
                ReactionableObjectHelper.removeReaction((ModifiableModelLessDataHolder)reactionableObject, (UserIdentity)userStatusInfo.getUserIdentity(), (ReactionableObject.ReactionType)type);
                parentNode.getSession().save();
                ++handled;
            }
        }
        if (handled > 0) {
            ForensicLogger.info((String)("data.policy.gdpr.remove." + this.getLogCategory() + ".reactions"), Map.of("handled", Long.toString(handled), "identity", userStatusInfo.getUserIdentity()), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
        }
        return handled;
    }

    protected record HandlingResult(int handled, int failed) {
    }
}

