/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.documents.WorkspaceExplorerResourceDAO;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class SendMailOnFileManagerStorageSpaceLimitreachedObserver
implements AsyncObserver,
Serviceable,
Contextualizable {
    protected WorkspaceExplorerResourceDAO _workspaceExplorerResourceDAO;
    protected ProjectManager _projectManager;
    protected WorkspacesHelper _workspaceHelper;
    protected DocumentWorkspaceModule _documentModule;
    protected Context _context;
    protected RenderingContextHandler _renderingContextHandler;

    public void service(ServiceManager manager) throws ServiceException {
        this._workspaceExplorerResourceDAO = (WorkspaceExplorerResourceDAO)((Object)manager.lookup(WorkspaceExplorerResourceDAO.ROLE));
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._documentModule = (DocumentWorkspaceModule)moduleManagerEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public boolean supports(Event event) {
        return "resource.created".equals(event.getId());
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        String parenIt = (String)event.getArguments().get("object.parent");
        Long storageSpaceLimit = this._workspaceExplorerResourceDAO.getStorageSpaceLimit();
        Project project = this._projectManager.getParentProject(parenIt);
        Long usedStorageSpace = this._workspaceExplorerResourceDAO.getUsedStorageSpaceByProject(project);
        if (storageSpaceLimit != null && usedStorageSpace >= storageSpaceLimit) {
            this._sendMail(project, true);
            return;
        }
        if (storageSpaceLimit != null && (double)usedStorageSpace.longValue() >= (double)storageSpaceLimit.longValue() * 0.95) {
            this._sendMail(project, false);
        }
    }

    private void _sendMail(Project project, boolean isFull) throws MessagingException, IOException {
        String part = isFull ? "FULL" : "ALMOST_FULL";
        String mailFrom = (String)Config.getInstance().getValue("smtp.mail.from");
        HashMap<String, I18nizableText> params = new HashMap<String, I18nizableText>();
        params.put("project", new I18nizableText(project.getTitle()));
        params.put("projectTitle", new I18nizableText(project.getTitle()));
        params.put("projectUrl", new I18nizableText(this._projectManager.getProjectUrl(project, "")));
        String url = this._getModuleURL(project);
        StandardMailBodyHelper.MailBodyBuilder htmlBodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STORAGE_SPACE_" + part + "_MANAGER_MAIL_TITLE", params)).withMessage(new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STORAGE_SPACE_" + part + "_MANAGER_MAIL_BODY_HTML", params)).withLink(url, new I18nizableText("plugin.workspaces", "PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT"));
        I18nizableText i18nSubject = new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STORAGE_SPACE_" + part + "_MANAGER_MAIL_SUBJECT", params);
        I18nizableText i18nTextBody = new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_STORAGE_SPACE_" + part + "_MANAGER_MAIL_BODY_TEXT", params);
        this._workspaceHelper.sendMailToManagers(project, mailFrom, i18nSubject, htmlBodyBuilder, i18nTextBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getModuleURL(Project project) {
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute("forceAbsoluteUrl", (Object)true);
        RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
        this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
        String url = null;
        try {
            url = this._documentModule.getModuleUrl(project);
        }
        finally {
            this._renderingContextHandler.setRenderingContext(currentContext);
        }
        return url;
    }
}

