/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.observation.AbstractNotifierAction;
import org.ametys.plugins.explorer.resources.AddOrUpdateResource;
import org.ametys.plugins.workspaces.documents.WorkspaceExplorerResourceDAO;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.Part;

public class AddOrUpdateResourceAction
extends AbstractNotifierAction {
    protected AddOrUpdateResource _addOrUpdateResource;
    protected WorkspaceExplorerResourceDAO _workspaceExplorerResourceDAO;
    protected ProjectManager _projectManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._addOrUpdateResource = (AddOrUpdateResource)serviceManager.lookup(AddOrUpdateResource.ROLE);
        this._workspaceExplorerResourceDAO = (WorkspaceExplorerResourceDAO)((Object)serviceManager.lookup(WorkspaceExplorerResourceDAO.ROLE));
        this._projectManager = (ProjectManager)((Object)serviceManager.lookup(ProjectManager.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Part part = (Part)request.get("filename");
        String parentId = request.getParameter("collection");
        String projectName = request.getParameter("projectName");
        if (projectName != null && !projectName.isEmpty()) {
            Long storageSpaceLimit = this._workspaceExplorerResourceDAO.getStorageSpaceLimit();
            Project project = this._projectManager.getProject(projectName);
            Long usedStorageSpace = this._workspaceExplorerResourceDAO.getUsedStorageSpaceByProject(project);
            if (storageSpaceLimit != null && usedStorageSpace + (long)part.getSize() > storageSpaceLimit) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", false);
                result.put("message", Map.of(part.getFileName(), "exceed-max-size"));
                request.setAttribute(JSonReader.OBJECT_TO_READ, result);
                return EMPTY_MAP;
            }
        }
        boolean unzip = Boolean.valueOf(request.getParameter("unzip"));
        String rawMode = parameters.getParameter("mode", "add");
        if (unzip) {
            rawMode = "add-unzip";
        }
        this._addOrUpdateResource.addOrUpdateResources(parentId, rawMode, Boolean.valueOf(unzip), List.of(part));
        return EMPTY_MAP;
    }
}

