/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.observers;

import java.util.Map;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.documents.onlyoffice.OnlyOfficeManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class FileThumbnailObserver
implements AsyncObserver,
Serviceable {
    protected OnlyOfficeManager _onlyOfficeManager;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._onlyOfficeManager = (OnlyOfficeManager)((Object)manager.lookup(OnlyOfficeManager.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public int getPriority() {
        return 0;
    }

    public boolean supports(Event event) {
        return this._onlyOfficeManager.isOnlyOfficeAvailable() && (event.getId().equals("resource.created") || event.getId().equals("resource.updated") || event.getId().equals("resource.deleted") || event.getId().equals("collection.deleting") || event.getId().equals("project.deleted"));
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Map args = event.getArguments();
        UserIdentity currentUser = event.getIssuer();
        if (event.getId().equals("project.deleted")) {
            String projectName = (String)event.getArguments().get("project.name");
            this._onlyOfficeManager.deleteProjectThumbnailsInCache(projectName);
        } else {
            String parentId = (String)args.get("object.parent");
            AmetysObject ao = this._resolver.resolveById(parentId);
            Project project = this.getProject(ao);
            if (project != null) {
                String projectName = project.getName();
                if (event.getId().equals("resource.created")) {
                    Map resources = (Map)args.get("resources");
                    for (String resourceId : resources.keySet()) {
                        this._onlyOfficeManager.generateThumbnailInCache(projectName, resourceId, currentUser);
                    }
                } else if (event.getId().equals("resource.updated")) {
                    String resourceId = (String)args.get("object.id");
                    this._onlyOfficeManager.deleteThumbnailInCache(projectName, resourceId);
                    this._onlyOfficeManager.generateThumbnailInCache(projectName, resourceId, currentUser);
                } else if (event.getId().equals("resource.deleted")) {
                    String resourceId = (String)args.get("object.id");
                    this._onlyOfficeManager.deleteThumbnailInCache(projectName, resourceId);
                } else if (event.getId().equals("collection.deleting")) {
                    String resourceCollectionId = (String)args.get("object.id");
                    ResourceCollection resourceCollection = (ResourceCollection)this._resolver.resolveById(resourceCollectionId);
                    this._deleteResourcesInCaches(projectName, resourceCollection);
                }
            }
        }
    }

    protected void _deleteResourcesInCaches(String projectName, ResourceCollection resourceCollection) {
        for (AmetysObject child : resourceCollection.getChildren()) {
            if (child instanceof ResourceCollection) {
                this._deleteResourcesInCaches(projectName, (ResourceCollection)child);
                continue;
            }
            if (!(child instanceof Resource)) continue;
            this._onlyOfficeManager.deleteThumbnailInCache(projectName, child.getId());
        }
    }

    protected Project getProject(AmetysObject ao) {
        for (AmetysObject parentAO = ao; parentAO != null; parentAO = parentAO.getParent()) {
            if (!(parentAO instanceof Project)) continue;
            return (Project)parentAO;
        }
        return null;
    }
}

