/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.data.Resource;
import org.ametys.cms.repository.AttachableAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.plugins.workspaces.forum.WorkspaceThreadDAO;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ForumWorkspaceModule
extends AbstractWorkspaceModule {
    public static final String FORUM_MODULE_ID = ForumWorkspaceModule.class.getName();
    public static final String FORUM_SERVICE_ID = "org.ametys.plugins.workspaces.module.Forums";
    private static final String __WORKSPACES_FORUMS_NODE_NAME = "forums";
    private static final String __FORUM_NUMBER_HEADER_ID = "forums$forum_number";
    private WorkspaceThreadDAO _workspaceThreadDAO;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._workspaceThreadDAO = (WorkspaceThreadDAO)((Object)manager.lookup(WorkspaceThreadDAO.ROLE));
    }

    @Override
    public String getId() {
        return FORUM_MODULE_ID;
    }

    @Override
    public I18nizableText getModuleTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_FORUM_LABEL");
    }

    @Override
    public I18nizableText getModuleDescription() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_FORUM_DESCRIPTION");
    }

    @Override
    public String getModuleName() {
        return __WORKSPACES_FORUMS_NODE_NAME;
    }

    @Override
    public int getOrder() {
        return 30;
    }

    @Override
    public Set<String> getAllowedEventTypes() {
        return ImmutableSet.of((Object)"forumthread.created", (Object)"forumthread.modified", (Object)"forumthread.closed", (Object)"forumthread.deleted", (Object)"forumthread.commented", (Object)"forumthread.accepted", (Object[])new String[0]);
    }

    @Override
    protected String getModulePageName() {
        return "forum";
    }

    @Override
    protected I18nizableText getModulePageTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_NEW_FORUM_TITLE");
    }

    @Override
    protected void initializeModulePage(ModifiablePage forumPage) {
        ModifiableZone defaultZone = forumPage.createZone("default");
        String serviceId = FORUM_SERVICE_ID;
        ModifiableZoneItem defaultZoneItem = defaultZone.addZoneItem();
        defaultZoneItem.setType(ZoneItem.ZoneType.SERVICE);
        defaultZoneItem.setServiceId(serviceId);
        ModifiableModelAwareDataHolder serviceDataHolder = defaultZoneItem.getServiceParameters();
        serviceDataHolder.setValue("xslt", (Object)this._getDefaultXslt(serviceId));
    }

    public String getThreadUri(Project project, String threadId) {
        String moduleUrl = this.getModuleUrl(project);
        if (moduleUrl != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(moduleUrl);
            sb.append("#thread-").append(threadId);
            return sb.toString();
        }
        return null;
    }

    @Override
    public Map<String, Object> _getInternalStatistics(Project project, boolean isActive) {
        if (isActive) {
            return Map.of(__FORUM_NUMBER_HEADER_ID, this._workspaceThreadDAO.getThreadsCount(project));
        }
        return Map.of(__FORUM_NUMBER_HEADER_ID, __SIZE_INACTIVE);
    }

    @Override
    public long getModuleSize(Project project) {
        return this._workspaceThreadDAO.getProjectThreads(project, false).stream().map(AttachableAmetysObject::getAttachments).flatMap(Collection::stream).mapToLong(Resource::getLength).sum();
    }

    @Override
    public List<StatisticColumn> _getInternalStatisticModel() {
        return List.of(new StatisticColumn(__FORUM_NUMBER_HEADER_ID, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_FORUM_NUMBER")).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderElements").withType(StatisticsColumnType.LONG).withGroup("general$elements"));
    }

    @Override
    protected boolean _showModuleSize() {
        return true;
    }
}

