/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.indexing.solr;

import org.ametys.cms.indexing.IndexingException;
import org.ametys.cms.indexing.solr.DocumentProvider;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.indexing.solr.SolrProjectResourceIndexer;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.solr.client.solrj.SolrClient;
import org.slf4j.Logger;

public class ProjectDocumentProvider
extends AbstractLogEnabled
implements DocumentProvider,
Serviceable,
Contextualizable {
    private static final I18nizableText __LABEL = new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CONTENT_INDEXING_PROJETDOCUMENTPROVIDER");
    protected ProjectManager _projectManager;
    protected SolrProjectResourceIndexer _solrProjectResourceIndexer;
    protected DocumentWorkspaceModule _documentModule;
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._solrProjectResourceIndexer = (SolrProjectResourceIndexer)manager.lookup(SolrProjectResourceIndexer.ROLE);
        WorkspaceModuleExtensionPoint moduleManager = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._documentModule = (DocumentWorkspaceModule)moduleManager.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
    }

    public I18nizableText getLabel() {
        return __LABEL;
    }

    public void indexDocuments(String workspaceName, SolrClient solrClient) throws IndexingException {
        this.indexDocuments(workspaceName, solrClient, ProgressionTrackerFactory.createContainerProgressionTracker((String)"Index documents", (Logger)this.getLogger()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexDocuments(String workspaceName, SolrClient solrClient, ContainerProgressionTracker progressionTracker) throws IndexingException {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)workspaceName);
            this._indexProjects(workspaceName, solrClient, progressionTracker);
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    private void _indexProjects(String workspaceName, SolrClient solrClient, ContainerProgressionTracker progressionTracker) throws IndexingException {
        AmetysObjectIterable<Project> projects = this._projectManager.getProjects();
        if (projects.getSize() == 0L) {
            progressionTracker.addSimpleStep("noprojects", new I18nizableText("")).setSize(0L);
        } else {
            for (Project project : projects) {
                progressionTracker.addSimpleStep(project.getName(), new I18nizableText(project.getName()));
            }
            for (Project project : projects) {
                this._indexProject(workspaceName, project, solrClient, (SimpleProgressionTracker)progressionTracker.getStep(project.getName()));
            }
        }
    }

    private void _indexProject(String workspaceName, Project project, SolrClient solrClient, SimpleProgressionTracker progressionTracker) throws IndexingException {
        try {
            ModifiableResourceCollection documentRoot = this._documentModule.getModuleRoot(project, false);
            this.getLogger().info("Starting indexation of project resources for project {} ('{}') in workspace {}", new Object[]{project.getName(), project.getId(), workspaceName});
            this._solrProjectResourceIndexer.indexProjectResources((ResourceCollection)documentRoot, project, solrClient, progressionTracker);
        }
        catch (Exception e) {
            String error = String.format("Failed to index project %s in workspace %s", project.getName(), workspaceName);
            this.getLogger().error(error, (Throwable)e);
            throw new IndexingException(error, (Throwable)e);
        }
    }
}

