/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.keywords;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;
import org.ametys.cms.tag.jcr.JCRTag;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.workspaces.keywords.KeywordJCR;
import org.ametys.plugins.workspaces.keywords.KeywordJCRProvider;
import org.ametys.plugins.workspaces.keywords.KeywordProviderExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;

public class KeywordJCRDAO
extends AbstractJCRTagsDAO {
    public static final String ROLE = KeywordJCRDAO.class.getName();
    protected KeywordProviderExtensionPoint _tagProviderExtPt;
    protected RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._tagProviderExtPt = (KeywordProviderExtensionPoint)((Object)serviceManager.lookup(KeywordProviderExtensionPoint.ROLE));
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public ModifiableTraversableAmetysObject _getTagRootObject(String tagProviderId, Map<String, Object> contextualParameters) throws RepositoryException {
        KeywordJCRProvider provider = (KeywordJCRProvider)((Object)this._tagProviderExtPt.getExtension(tagProviderId));
        return provider.getRootNode(contextualParameters);
    }

    protected void _checkUserRight() throws IllegalStateException {
        if (this._rightManager.currentUserHasRight("Workspace_Rights_Keywords_HandleKeyword", (Object)"/admin") != RightManager.RightResult.RIGHT_ALLOW) {
            UserIdentity user = this._currentUserProvider.getUser();
            this.getLogger().error("User '" + String.valueOf(user) + "' tried to access a privileged feature without convenient right. Should have right 'Workspace_Rights_Keywords_HandleKeyword' on context '/admin'");
            throw new IllegalStateException("You have no right to access this feature.");
        }
    }

    protected Tag _getTagFromName(String name, Map<String, Object> contextualParameters) {
        return this._tagProviderExtPt.getTag(name, contextualParameters);
    }

    protected JCRTag _createJCRTag(String parentId, String name, String title, String description, Map<String, Object> otherParameters, Map<String, Object> contextualParameters) throws RepositoryException {
        ModifiableTraversableAmetysObject parent = null;
        parent = StringUtils.isEmpty((CharSequence)parentId) ? this._getTagRootObject(KeywordJCRProvider.class.getName(), contextualParameters) : (ModifiableTraversableAmetysObject)this._resolver.resolveById(parentId);
        KeywordJCR jcrCategory = (KeywordJCR)parent.createChild(name, "ametys:project-keyword");
        jcrCategory.setTitle(title);
        jcrCategory.setDescription(description);
        parent.saveChanges();
        return jcrCategory;
    }

    protected JCRTag _updateJCRTag(String tagId, String title, String description, Map<String, Object> otherParameters) throws UnknownAmetysObjectException {
        KeywordJCR jcrCategory = (KeywordJCR)this._resolver.resolveById(tagId);
        jcrCategory.setTitle(title);
        jcrCategory.setDescription(description);
        jcrCategory.saveChanges();
        return jcrCategory;
    }

    protected Set<TagProvider<? extends Tag>> _getTagProviders() {
        HashSet<TagProvider<? extends Tag>> providers = new HashSet<TagProvider<? extends Tag>>();
        Set ids = this._tagProviderExtPt.getExtensionsIds();
        for (String id : ids) {
            TagProvider provider = (TagProvider)this._tagProviderExtPt.getExtension(id);
            providers.add((TagProvider<? extends Tag>)provider);
        }
        return providers;
    }

    @Callable(rights={"Workspace_Rights_Keywords_HandleKeyword"}, context="/admin")
    public Map<String, Object> getTagRootNode(String tagProviderId, Map<String, Object> contextualParameters) throws ProcessingException {
        return super.getTagRootNode(tagProviderId, contextualParameters);
    }

    @Callable(rights={"Workspace_Rights_Keywords_HandleKeyword"}, context="/admin")
    public Map<String, Object> getTag(String tagId) {
        return super.getTag(tagId);
    }
}

