/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.news;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.Resource;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.Query;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.search.query.SiteQuery;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class NewsWorkspaceModule
extends AbstractWorkspaceModule {
    public static final String NEWS_MODULE_ID = NewsWorkspaceModule.class.getName();
    public static final String NEWS_SERVICE_ID = "org.ametys.web.service.SearchService";
    public static final String NEWS_PAGE_TEMPLATE = "news";
    protected static final String[] SEARCH_SERVICE_CONTENT_TYPES = new String[]{"org.ametys.plugins.workspaces.Content.projectNews"};
    protected static final String[] SEARCH_SERVICE_RETURNABLES = new String[]{"org.ametys.web.frontoffice.search.metamodel.impl.ContentReturnable"};
    protected static final String[] SEARCH_SERVICE_SORTS = new String[]{"{\"name\":\"ContentReturnable$ContentSearchable$org.ametys.plugins.workspaces.Content.abstractNews$start-date\",\"sort\":\"DESC\"}", "{\"name\":\"ContentReturnable$ContentSearchable$org.ametys.plugins.workspaces.Content.abstractNews$end-date\",\"sort\":\"DESC\"}"};
    protected static final String[] SEARCH_SERVICE_CONTEXTS = new String[]{"{\"sites\":\"{\\\"context\\\":\\\"CURRENT_SITE\\\",\\\"sites\\\":[]}\",\"search-sitemap-context\":\"{\\\"context\\\":\\\"CURRENT_SITE\\\",\\\"page\\\":null}\",\"context-lang\":\"CURRENT\",\"tags\":[]}"};
    protected static final String SEARCH_SEARCH_CONTENT_VIEW = "portlet";
    protected static final String SEARCH_SERVICE_XSLT = "pages/services/search/project-news.xsl";
    private static final String __WORKSPACES_NEWS_NODE_NAME = "news";
    private static final String __NEWS_NUMBER_HEADER_ID = "news$news_number";
    private ContentSearcherFactory _contentSearcherFactory;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._contentSearcherFactory = (ContentSearcherFactory)smanager.lookup(ContentSearcherFactory.ROLE);
    }

    @Override
    public String getId() {
        return NEWS_MODULE_ID;
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    public String getModuleName() {
        return "news";
    }

    @Override
    public Set<String> getAllowedEventTypes() {
        return Set.of("project.news.published", "content.comment.validated");
    }

    @Override
    protected String getModulePageName() {
        return "news";
    }

    @Override
    public I18nizableText getModuleTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_MODULE_NEWS_LABEL");
    }

    @Override
    public I18nizableText getModuleDescription() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_MODULE_NEWS_DESCRIPTION");
    }

    @Override
    protected I18nizableText getModulePageTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_NEWS_TITLE");
    }

    @Override
    protected ModifiablePage _createModulePage(Project project, Sitemap sitemap, String name, I18nizableText pageTitle, String skinTemplate) {
        if (!sitemap.hasChild(name)) {
            ModifiablePage page = (ModifiablePage)sitemap.createChild(name, "ametys:defaultPage");
            page.setTitle((String)StringUtils.defaultIfEmpty((CharSequence)this._i18nUtils.translate((I18nizable)pageTitle, sitemap.getName()), (CharSequence)"Missing title"));
            page.setType(Page.PageType.CONTAINER);
            page.setTemplate("news");
            page.setSiteName(sitemap.getSiteName());
            page.setSitemapName(sitemap.getName());
            sitemap.saveChanges();
            return page;
        }
        return null;
    }

    @Override
    protected void initializeModulePage(ModifiablePage modulePage) {
        modulePage.untag("SECTION");
        ModifiableZone defaultZone = modulePage.hasZone("default") ? modulePage.getZone("default") : modulePage.createZone("default");
        boolean hasService = defaultZone.getZoneItems().stream().anyMatch(zi -> NEWS_SERVICE_ID.equals(zi.getServiceId()));
        if (!hasService) {
            ModifiableZoneItem defaultZoneItem = defaultZone.addZoneItem();
            defaultZoneItem.setType(ZoneItem.ZoneType.SERVICE);
            defaultZoneItem.setServiceId(NEWS_SERVICE_ID);
            ModifiableModelAwareDataHolder serviceDataHolder = defaultZoneItem.getServiceParameters();
            serviceDataHolder.setValue("header", null);
            serviceDataHolder.setValue("contentTypes", (Object)SEARCH_SERVICE_CONTENT_TYPES);
            serviceDataHolder.setValue("returnables", (Object)SEARCH_SERVICE_RETURNABLES);
            serviceDataHolder.setValue("initialSorts", (Object)SEARCH_SERVICE_SORTS);
            serviceDataHolder.setValue("contexts", (Object)SEARCH_SERVICE_CONTEXTS);
            serviceDataHolder.setValue("resultsPerPage", (Object)12);
            serviceDataHolder.setValue("rightCheckingMode", (Object)"exact");
            serviceDataHolder.setValue("resultPlace", (Object)"ABOVE_CRITERIA");
            serviceDataHolder.setValue("launchSearchAtStartup", (Object)true);
            serviceDataHolder.setValue("rss", (Object)false);
            serviceDataHolder.setValue("contentView", (Object)SEARCH_SEARCH_CONTENT_VIEW);
            serviceDataHolder.setValue("xslt", (Object)SEARCH_SERVICE_XSLT);
        }
    }

    @Override
    protected String getModulePageTemplate() {
        return "page";
    }

    @Override
    public Map<String, Object> _getInternalStatistics(Project project, boolean isActive) {
        if (isActive) {
            HashMap<String, Object> statistics = new HashMap<String, Object>();
            try {
                AmetysObjectIterable results = this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.projectNews"}).search((Query)new SiteQuery(new String[]{project.getName()}));
                statistics.put(__NEWS_NUMBER_HEADER_ID, results.getSize());
            }
            catch (Exception e) {
                this.getLogger().error("Error searching news content images in project " + project.getId(), (Throwable)e);
            }
            return statistics;
        }
        return Map.of(__NEWS_NUMBER_HEADER_ID, __SIZE_INACTIVE);
    }

    @Override
    public List<StatisticColumn> _getInternalStatisticModel() {
        return List.of(new StatisticColumn(__NEWS_NUMBER_HEADER_ID, new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_NEWS_NUMBER")).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderElements").withType(StatisticsColumnType.LONG).withGroup("general$elements"));
    }

    @Override
    public long getModuleSize(Project project) {
        try {
            AmetysObjectIterable results = this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.projectNews"}).search((Query)new SiteQuery(new String[]{project.getName()}));
            return results.stream().map(content -> content.getValue("illustration/image")).filter(Objects::nonNull).filter(Binary.class::isInstance).map(Binary.class::cast).mapToLong(Resource::getLength).sum();
        }
        catch (Exception e) {
            this.getLogger().error("Error searching news images in project " + project.getId(), (Throwable)e);
            return -1L;
        }
    }

    @Override
    protected boolean _showModuleSize() {
        return true;
    }

    @Override
    protected boolean _showActivatedStatus() {
        return false;
    }
}

