/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.preferences;

import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.plugins.workspaces.AbstractWorkspaceDAO;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class WorkspaceViewUserPreferencesDAO
extends AbstractWorkspaceDAO {
    public static final String ROLE = WorkspaceViewUserPreferencesDAO.class.getName();
    public static final String VIEW_USER_PREF_CONTEXT = "/workspaces/view";
    protected UserPreferencesManager _userPrefsManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userPrefsManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
    }

    @Callable(rights={"*"})
    public void setUserPreference(String moduleId, String preferences) {
        try {
            this._userPrefsManager.addUserPreference(this._currentUserProvider.getUser(), VIEW_USER_PREF_CONTEXT, Map.of(), moduleId, preferences);
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occured while setting the user preferences.", (Throwable)e);
        }
    }

    @Callable(rights={"*"})
    public String getUserPreference(String moduleId) {
        String userPreference = null;
        try {
            userPreference = this._userPrefsManager.getUserPreferenceAsString(this._currentUserProvider.getUser(), VIEW_USER_PREF_CONTEXT, Map.of(), moduleId);
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occured while getting the user preferences.", (Throwable)e);
        }
        return userPreference;
    }
}

