/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.generators;

import java.time.ZonedDateTime;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.forums.ThreadDeletedActivityType;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.forum.jcr.JCRThread;
import org.ametys.plugins.workspaces.forum.json.ThreadJSONHelper;
import org.ametys.plugins.workspaces.project.generators.AbstractMailNotifierGenerator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ForumMailNotifierGenerator
extends AbstractMailNotifierGenerator {
    private AmetysObjectResolver _resolver;
    private ThreadJSONHelper _threadJSONHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._threadJSONHelper = (ThreadJSONHelper)((Object)this.manager.lookup(ThreadJSONHelper.ROLE));
    }

    @Override
    protected void saxAdditionalData(Activity activity) throws SAXException {
        try {
            JCRThread thread = (JCRThread)this._resolver.resolveById((String)activity.getValue("threadId"));
            this._saxComments(thread, activity);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"modulePageId", (String)thread.getId());
            if (activity.getActivityType() instanceof ThreadDeletedActivityType) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"deleted");
            }
        }
        catch (UnknownAmetysObjectException unknownAmetysObjectException) {
            // empty catch block
        }
    }

    private void _saxComments(JCRThread thread, Activity currentActivity) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"comments");
        String currentCommentId = (String)currentActivity.getValue("commentId");
        for (RichTextComment comment : thread.getFlattenComments(true, true)) {
            AttributesImpl attr = new AttributesImpl();
            if (comment.getId().equals(currentCommentId)) {
                attr.addCDATAAttribute("currentActivity", "true");
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"comment", (Attributes)attr);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"authorName", (String)comment.getAuthorName());
            UserIdentity userIdentity = comment.getAuthor();
            if (userIdentity != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"login", (String)userIdentity.getLogin());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"populationId", (String)userIdentity.getPopulationId());
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"creationDate", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)comment.getCreationDate()));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"content", (String)this._threadJSONHelper.richTextToSimpleText(comment.getRichTextContent(), 150));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"comment");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"comments");
    }

    @Override
    protected String _getModuleId() {
        return ForumWorkspaceModule.FORUM_MODULE_ID;
    }
}

