/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.helper;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.cms.tag.Tag;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.dom.AmetysNodeList;
import org.ametys.core.util.dom.MapElement;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.activities.activitystream.ActivityStreamClientInteraction;
import org.ametys.plugins.workspaces.alert.AlertWorkspaceModule;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryHelper;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.keywords.KeywordsDAO;
import org.ametys.plugins.workspaces.news.NewsWorkspaceModule;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebConstants;
import org.ametys.web.cocoon.I18nUtils;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.transformation.xslt.AmetysXSLTHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectXsltHelper
implements Serviceable,
Contextualizable,
LogEnabled {
    private static Logger _logger;
    private static Context _context;
    private static ProjectManager _projectManager;
    private static CategoryProviderExtensionPoint _categoryProviderEP;
    private static CategoryHelper _categoryHelper;
    private static I18nUtils _i18nUtils;
    private static ActivityStreamClientInteraction _activityStream;
    private static LanguagesManager _languagesManager;
    private static CurrentUserProvider _currentUserProvider;
    private static KeywordsDAO _keywordsDAO;
    private static WorkspacesHelper _workspaceHelper;
    private static ProjectRightHelper _projectRightHelper;
    private static ProjectRightHelper _projectRightsHelper;

    public void contextualize(Context context) throws ContextException {
        _context = context;
    }

    public void enableLogging(Logger logger) {
        _logger = logger;
    }

    public void service(ServiceManager manager) throws ServiceException {
        _projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        _categoryProviderEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
        _categoryHelper = (CategoryHelper)manager.lookup(CategoryHelper.ROLE);
        _i18nUtils = (I18nUtils)manager.lookup(org.ametys.core.util.I18nUtils.ROLE);
        _activityStream = (ActivityStreamClientInteraction)((Object)manager.lookup(ActivityStreamClientInteraction.ROLE));
        _languagesManager = (LanguagesManager)manager.lookup(LanguagesManager.ROLE);
        _currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        _keywordsDAO = (KeywordsDAO)((Object)manager.lookup(KeywordsDAO.ROLE));
        _workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        _projectRightHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        _projectRightsHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
    }

    public static String project() {
        Project project = _workspaceHelper.getProjectFromRequest();
        if (project == null && _logger.isWarnEnabled()) {
            String warnMsg = String.format("No project was found for current site", new Object[0]);
            _logger.warn(warnMsg);
        }
        return project != null ? project.getName() : null;
    }

    public static MapElement projectInfo() {
        return ProjectXsltHelper.projectInfo(ProjectXsltHelper.project());
    }

    public static MapElement projectInfo(String projectName) {
        HashMap<String, Object> projectInfo = new HashMap<String, Object>();
        Project project = _projectManager.getProject(projectName);
        if (project != null) {
            projectInfo.put("name", project.getName());
            projectInfo.put("id", project.getId());
            projectInfo.put("title", project.getTitle());
            projectInfo.put("description", project.getDescription());
            projectInfo.put("creationDate", ProjectXsltHelper._projectCreationDate(project));
            projectInfo.put("lastActivityDate", ProjectXsltHelper.projectLastActivityDate(project.getName()));
            projectInfo.put("categoryLabel", ProjectXsltHelper._projectCategoryLabel(project));
            projectInfo.put("categoryColor", ProjectXsltHelper._projectCategoryColor(project));
            projectInfo.put("keyword", ProjectXsltHelper._projectKeywords(project));
        }
        return new MapElement("project", projectInfo);
    }

    public static String projectTitle() {
        return ProjectXsltHelper.projectTitle(ProjectXsltHelper.project());
    }

    public static String projectTitle(String projectName) {
        String title = "";
        Project project = _projectManager.getProject(projectName);
        if (project != null) {
            title = project.getTitle();
        }
        return title;
    }

    public static String projectDescription() {
        return ProjectXsltHelper.projectDescription(ProjectXsltHelper.project());
    }

    public static String projectDescription(String projectName) {
        String title = "";
        Project project = _projectManager.getProject(projectName);
        if (project != null) {
            title = project.getDescription();
        }
        return title;
    }

    public static NodeList userProjects() {
        ArrayList userProjects = new ArrayList();
        _projectManager.getUserProjects(_currentUserProvider.getUser()).forEach((project, memberType) -> {
            HashMap<String, String> projectInfo = new HashMap<String, String>();
            projectInfo.put("name", project.getName());
            projectInfo.put("id", project.getId());
            projectInfo.put("title", project.getTitle());
            userProjects.add(new MapElement("project", projectInfo));
        });
        return new AmetysNodeList(userProjects);
    }

    public static NodeList projectKeywords() {
        return ProjectXsltHelper.projectKeywords(ProjectXsltHelper.project());
    }

    public static NodeList projectKeywords(String projectName) {
        ArrayList<MapElement> keywordsElmts = new ArrayList<MapElement>();
        Project project = _projectManager.getProject(projectName);
        if (project != null) {
            List<Map<String, String>> keywords = ProjectXsltHelper._projectKeywords(project);
            for (Map<String, String> keyword : keywords) {
                keywordsElmts.add(new MapElement("keyword", keyword));
            }
        }
        return new AmetysNodeList(keywordsElmts);
    }

    private static List<Map<String, String>> _projectKeywords(Project project) {
        ArrayList<Map<String, String>> keywords = new ArrayList<Map<String, String>>();
        for (String keyword : project.getKeywords()) {
            Tag tag = _keywordsDAO.getTag(keyword, Collections.emptyMap());
            if (tag == null) continue;
            String title = _i18nUtils.translate((I18nizable)tag.getTitle(), AmetysXSLTHelper.lang());
            keywords.add(Map.of("title", title, "name", keyword));
        }
        return keywords;
    }

    public static String projectCreationDate() {
        return ProjectXsltHelper.projectCreationDate(ProjectXsltHelper.project());
    }

    public static String projectCreationDate(String projectName) {
        String creationDate = "";
        Project project = _projectManager.getProject(projectName);
        if (project != null) {
            creationDate = ProjectXsltHelper._projectCreationDate(project);
        }
        return creationDate;
    }

    private static String _projectCreationDate(Project project) {
        ZonedDateTime date = project.getCreationDate();
        return date.format(DateUtils.getISODateTimeFormatter());
    }

    public static MapElement projectCategoryColor() {
        return ProjectXsltHelper.projectCategoryColor(ProjectXsltHelper.project());
    }

    public static MapElement projectCategoryColor(String projectName) {
        Project project = _projectManager.getProject(projectName);
        Map<String, String> color = ProjectXsltHelper._projectCategoryColor(project);
        return new MapElement("color", color);
    }

    private static Map<String, String> _projectCategoryColor(Project project) {
        Category category = ProjectXsltHelper._getFirstCategory(project);
        return ProjectXsltHelper._categoryColor(category);
    }

    public static MapElement categoryColor(String categoryId) {
        Category category = (Category)_categoryProviderEP.getTag(categoryId, null);
        return ProjectXsltHelper.categoryColor(category);
    }

    public static MapElement categoryColor(Category category) {
        Map<String, String> color = ProjectXsltHelper._categoryColor(category);
        return new MapElement("color", color);
    }

    private static Map<String, String> _categoryColor(Category category) {
        return _categoryHelper.getCategoryColor(category);
    }

    private static Category _getFirstCategory(Project project) {
        if (project != null) {
            for (String categoryId : project.getCategories()) {
                Category category = (Category)_categoryProviderEP.getTag(categoryId, null);
                if (category == null) continue;
                return category;
            }
        }
        return null;
    }

    public static String projectCategoryLabel() {
        return ProjectXsltHelper.projectCategoryLabel(ProjectXsltHelper.project());
    }

    public static String projectCategoryLabel(String projectName) {
        Project project = _projectManager.getProject(projectName);
        if (project != null) {
            return ProjectXsltHelper._projectCategoryLabel(project);
        }
        return null;
    }

    private static String _projectCategoryLabel(Project project) {
        Category category = ProjectXsltHelper._getFirstCategory(project);
        if (category != null) {
            return _i18nUtils.translate((I18nizable)category.getTitle(), AmetysXSLTHelper.lang());
        }
        return null;
    }

    public static String projectLastActivityDate() {
        return ProjectXsltHelper.projectLastActivityDate(ProjectXsltHelper.project());
    }

    public static String projectLastActivityDate(String projectName) {
        ZonedDateTime lastDate = _activityStream.getDateOfLastActivity(projectName, Arrays.asList("member.added", "member.deleted"));
        return lastDate != null ? lastDate.format(DateUtils.getISODateTimeFormatter()) : ProjectXsltHelper.projectCreationDate();
    }

    public static boolean isResourceFromWorkspace(String resourceId) {
        return _projectManager.getParentProject(resourceId) != null;
    }

    public static Node resourceSite(String projectResourceId) {
        Project project = _projectManager.getParentProject(projectResourceId);
        if (project != null) {
            Site site = project.getSite();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", site.getName());
            attributes.put("id", site.getId());
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("title", site.getTitle());
            values.put("url", site.getUrl());
            return new MapElement("site", attributes, values);
        }
        return null;
    }

    public static String getNewsRootPageId() {
        Request request = ContextHelper.getRequest((Context)_context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            String string = ProjectXsltHelper.getModulePage(NewsWorkspaceModule.NEWS_MODULE_ID);
            return string;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    public static String getAlertsRootPageId() {
        Request request = ContextHelper.getRequest((Context)_context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            String string = ProjectXsltHelper.getModulePage(AlertWorkspaceModule.ALERT_MODULE_ID);
            return string;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    public static String getModulePage(String moduleId) {
        String projectName = ProjectXsltHelper.project();
        Project project = _projectManager.getProject(projectName);
        Set<Page> newsRootPages = _projectManager.getModulePages(project, moduleId);
        Iterator<Page> it = newsRootPages.iterator();
        if (it.hasNext()) {
            return it.next().getId();
        }
        return null;
    }

    public static String getLanguageLabel(String code, String language) {
        I18nizableText label = _languagesManager.getLanguage(code).getLabel();
        return _i18nUtils.translate((I18nizable)label, language);
    }

    public static String computeDefaultLanguage(String language) {
        Request request = ContextHelper.getRequest((Context)_context);
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        ModelAwareDataHolder dataHolder = zoneItem.getServiceParameters();
        String[] availableLanguages = (String[])dataHolder.getValue("availableLanguages");
        if (Arrays.stream(availableLanguages).anyMatch(l -> l.equals(language))) {
            return language;
        }
        if (Arrays.stream(availableLanguages).anyMatch(l -> l.equals("en"))) {
            return "en";
        }
        return availableLanguages[0];
    }

    public static boolean isManager() {
        UserIdentity user = _currentUserProvider.getUser();
        String projectName = ProjectXsltHelper.project();
        return _projectManager.isManager(projectName, user);
    }

    public static boolean isManager(String login, String populationId) {
        String projectName = ProjectXsltHelper.project();
        UserIdentity user = new UserIdentity(login, populationId);
        return _projectManager.isManager(projectName, user);
    }

    public static boolean isManager(String projectName) {
        UserIdentity user = _currentUserProvider.getUser();
        return _projectManager.isManager(projectName, user);
    }

    public static boolean isManager(String projectName, String login, String populationId) {
        UserIdentity user = new UserIdentity(login, populationId);
        return _projectManager.isManager(projectName, user);
    }

    public static boolean hasRightOnModule(String rightId, String moduleId) {
        return _projectRightHelper.hasRightOnModule(rightId, moduleId);
    }

    public static boolean canAccessBO() {
        String projectName = ProjectXsltHelper.project();
        Project project = _projectManager.getProject(projectName);
        return project != null ? _projectManager.canAccessBO(project) : false;
    }

    public static boolean canLeaveProject() {
        String projectName = ProjectXsltHelper.project();
        Project project = _projectManager.getProject(projectName);
        return project != null ? _projectManager.canLeaveProject(project) : false;
    }

    public String getMemberStatus(String userAsString) {
        UserIdentity user = UserIdentity.stringToUserIdentity((String)userAsString);
        String projectName = ProjectXsltHelper.project();
        Project project = _projectManager.getProject(projectName);
        if (user == null || !_projectRightsHelper.hasReadAccessOnModule(project, ForumWorkspaceModule.FORUM_MODULE_ID, user)) {
            return "not-allowed";
        }
        if (user.equals((Object)_currentUserProvider.getUser())) {
            return "current-user";
        }
        return "allowed";
    }
}

