/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification.preferences;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class NotificationPreferencesHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String USERPREFS_ID = "workspaces.notifications";
    public static final String ROLE = NotificationPreferencesHelper.class.getName();
    protected JSONUtils _jsonUtils;
    protected UserPreferencesManager _userPrefManager;
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected ProjectManager _projectManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPrefManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE + ".FO");
        this._userPrefEP = (UserPreferencesExtensionPoint)manager.lookup(UserPreferencesExtensionPoint.ROLE + ".FO");
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public boolean askedToBeNotified(User user, String projectName, Frequency frequency) {
        return this.askedToBeNotified(user.getIdentity(), projectName, frequency);
    }

    public boolean askedToBeNotified(UserIdentity userIdentity, String projectName, Frequency frequency) {
        try {
            Map<String, Object> notificationPreferences = this.getNotificationPreferences(userIdentity);
            if (((Boolean)notificationPreferences.get("disable")).booleanValue()) {
                return false;
            }
            Map projectsPreferences = (Map)notificationPreferences.get("projects");
            if (!projectsPreferences.isEmpty() && projectsPreferences.get(projectName) != null) {
                Map projectPreference = (Map)projectsPreferences.get(projectName);
                return (Boolean)projectPreference.get("disable") == false && StringUtils.equalsIgnoreCase((CharSequence)frequency.name(), (CharSequence)((String)projectPreference.get("frequency")));
            }
            return StringUtils.equalsIgnoreCase((CharSequence)frequency.name(), (CharSequence)((String)notificationPreferences.get("frequency")));
        }
        catch (UserPreferencesException e) {
            this.getLogger().warn("Failed to retrieve the user preferences for user {}", (Object)UserIdentity.userIdentityToString((UserIdentity)userIdentity), (Object)e);
            return false;
        }
    }

    public Set<String> getPausedProjects(UserIdentity user) {
        try {
            Map<String, Object> notificationPreferences = this.getNotificationPreferences(user);
            if (Boolean.TRUE.equals(notificationPreferences.get("disable"))) {
                return null;
            }
            HashSet<String> paused = new HashSet<String>();
            Map projectsPreferences = (Map)notificationPreferences.get("projects");
            for (Map.Entry projectPreference : projectsPreferences.entrySet()) {
                if (!Boolean.TRUE.equals(((Map)projectPreference.getValue()).get("disable"))) continue;
                paused.add((String)projectPreference.getKey());
            }
            return paused;
        }
        catch (UserPreferencesException e) {
            this.getLogger().warn("Failed to retrieve the user preferences for user {}", (Object)UserIdentity.userIdentityToString((UserIdentity)user), (Object)e);
            return Set.of();
        }
    }

    @Callable(rights={"*"})
    public boolean setPauseProject(String projectName, boolean pause) {
        UserIdentity user = this._currentUserProvider.getUser();
        try {
            Map<String, Object> notificationPreferences = this.getNotificationPreferences(user);
            Map projectsPreferences = (Map)notificationPreferences.computeIfAbsent("projects", s -> new HashMap());
            Map projectPreference = (Map)projectsPreferences.computeIfAbsent(projectName, s -> new HashMap());
            if (!pause && notificationPreferences.get("frequency").equals(projectPreference.get("frequency"))) {
                projectsPreferences.remove(projectName);
            } else {
                projectPreference.put("disable", pause);
                projectPreference.computeIfAbsent("frequency", s -> notificationPreferences.get("frequency"));
            }
            String preferencesAsString = this._jsonUtils.convertObjectToJson(notificationPreferences);
            Map values = this._userPrefManager.getUnTypedUserPrefs(user, this._getStorageContext(), Map.of());
            values.put(USERPREFS_ID, preferencesAsString);
            this._userPrefManager.setUserPreferences(user, this._getStorageContext(), Map.of(), values);
            return true;
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Could not change favorite status of user " + UserIdentity.userIdentityToString((UserIdentity)user) + " on project " + projectName);
            return false;
        }
    }

    public boolean hasFrequencyInPreferences(User user, Frequency frequency) {
        try {
            String notificationPreferencesJSON = this.getNotificationPreferencesAsString(user);
            return notificationPreferencesJSON.contains(frequency.name().toLowerCase());
        }
        catch (UserPreferencesException e) {
            this.getLogger().warn("Failed to retrieve the user preferences for user {}", (Object)user.getFullName(), (Object)e);
            return false;
        }
    }

    private boolean _isDisabled(Map<String, Map<String, Object>> projectPrefs, String projectName) {
        return projectPrefs.containsKey(projectName) && (Boolean)projectPrefs.get(projectName).get("disable") != false;
    }

    private boolean _matchFrequency(Map<String, Map<String, Object>> projectPrefs, String projectName, Frequency frequency) {
        return projectPrefs.containsKey(projectName) && StringUtils.equalsIgnoreCase((CharSequence)frequency.name(), (CharSequence)((String)projectPrefs.get(projectName).get("frequency")));
    }

    public Set<String> getUserProjectsWithFrequency(User user, Frequency frequency) {
        try {
            Map<String, Object> notificationPreferences = this.getNotificationPreferences(user);
            if (((Boolean)notificationPreferences.get("disable")).booleanValue()) {
                return Collections.EMPTY_SET;
            }
            String globalFrequency = (String)notificationPreferences.get("frequency");
            Map customProjectsPrefs = (Map)notificationPreferences.get("projects");
            if (globalFrequency.equals(frequency.name().toLowerCase())) {
                Set<Project> userProjects = this._projectManager.getUserProjects(user.getIdentity()).keySet();
                return userProjects.stream().map(SimpleAmetysObject::getName).filter(p -> !this._isDisabled(customProjectsPrefs, (String)p)).filter(p -> !customProjectsPrefs.containsKey(p) || this._matchFrequency(customProjectsPrefs, (String)p, frequency)).collect(Collectors.toSet());
            }
            return customProjectsPrefs.entrySet().stream().filter(e -> (Boolean)((Map)e.getValue()).get("disable") == false).filter(e -> frequency.name().toLowerCase().equals(((Map)e.getValue()).get("frequency"))).map(e -> (String)e.getKey()).collect(Collectors.toSet());
        }
        catch (UserPreferencesException e2) {
            this.getLogger().warn("Failed to retrieve the user preferences for user {}", (Object)user.getFullName(), (Object)e2);
            return Collections.EMPTY_SET;
        }
    }

    public Map<String, Object> getNotificationPreferences(User user) throws UserPreferencesException {
        return this.getNotificationPreferences(user.getIdentity());
    }

    public Map<String, Object> getNotificationPreferences(UserIdentity userIdentity) throws UserPreferencesException {
        String prefAsString = this.getNotificationPreferencesAsString(userIdentity);
        return this._jsonUtils.convertJsonToMap(prefAsString);
    }

    public String getNotificationPreferencesAsString(User user) throws UserPreferencesException {
        return this.getNotificationPreferencesAsString(user.getIdentity());
    }

    public String getNotificationPreferencesAsString(UserIdentity userIdentity) throws UserPreferencesException {
        String notificationPreferencesJSON = this._userPrefManager.getUserPreferenceAsString(userIdentity, this._getStorageContext(), Map.of(), USERPREFS_ID);
        if (notificationPreferencesJSON == null) {
            notificationPreferencesJSON = (String)this._userPrefEP.getUserPreference(Map.of(), USERPREFS_ID).getDefaultValue();
        }
        return notificationPreferencesJSON;
    }

    public void deleteProjectNotificationPreferences(UserIdentity userIdentity, String projectName) {
        try {
            Map projectsPreferences;
            Map values = this._userPrefManager.getUnTypedUserPrefs(userIdentity, this._getStorageContext(), Map.of());
            String notificationPreferencesJSON = (String)values.get(USERPREFS_ID);
            Map notificationPreferences = this._jsonUtils.convertJsonToMap(notificationPreferencesJSON);
            if (notificationPreferences.containsKey("projects") && (projectsPreferences = (Map)notificationPreferences.get("projects")).containsKey(projectName)) {
                projectsPreferences.remove(projectName);
                notificationPreferencesJSON = this._jsonUtils.convertObjectToJson((Object)notificationPreferences);
                values.put(USERPREFS_ID, notificationPreferencesJSON);
                this._userPrefManager.setUserPreferences(userIdentity, this._getStorageContext(), Map.of(), values);
            }
        }
        catch (UserPreferencesException e) {
            this.getLogger().warn("Failed to delete the notification user preference for project {} of user {}", new Object[]{projectName, UserIdentity.userIdentityToString((UserIdentity)userIdentity), e});
        }
    }

    private String _getStorageContext() {
        return "/sites/" + this._projectManager.getCatalogSiteName();
    }

    public static enum Frequency {
        EACH,
        DAILY,
        WEEKLY,
        MONTHLY;

    }
}

