/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.objects;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.ametys.cms.data.Binary;
import org.ametys.cms.indexing.solr.SolrAclCacheUninfluentialObject;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.activities.ActivityHolder;
import org.ametys.plugins.repository.activities.ActivityHolderAmetysObject;
import org.ametys.plugins.repository.activities.DefaultActivityHolder;
import org.ametys.plugins.repository.activities.DefaultActivityHolderFactory;
import org.ametys.plugins.repository.data.ametysobject.ModifiableModelLessDataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObjectHelper;
import org.ametys.plugins.workspaces.project.objects.ProjectFactory;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.commons.lang3.ArrayUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@SolrAclCacheUninfluentialObject
public class Project
extends DefaultTraversableAmetysObject<ProjectFactory>
implements ModifiableModelLessDataAwareAmetysObject,
ActivityHolderAmetysObject {
    public static final String NODE_TYPE = "ametys:project";
    public static final String DATA_SITE = "site";
    private static final String __EXPLORER_NODE_NAME = "ametys-internal:resources";
    private static final String __DATA_TITLE = "title";
    private static final String __DATA_DESCRIPTION = "description";
    private static final String __DATA_MAILING_LIST = "mailingList";
    private static final String __DATA_CREATION = "creationDate";
    private static final String __DATA_MANAGERS = "managers";
    private static final String __DATA_MODULES = "modules";
    private static final String __DATA_INSCRIPTION_STATUS = "inscriptionStatus";
    private static final String __DATA_DEFAULT_PROFILE = "defaultProfile";
    private static final String __DATA_COVERIMAGE = "coverImage";
    private static final String __DATA_KEYWORDS = "keywords";
    private static final String __PLUGINS_NODE_NAME = "ametys-internal:plugins";
    private static final String __DATA_CATEGORIES = "ametys-internal:categories";

    public Project(Node node, String parentPath, ProjectFactory factory) {
        super(node, parentPath, (DefaultTraversableAmetysObjectFactory)factory);
    }

    public ModifiableModelLessDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelLessDataHolder((ModelItemTypeExtensionPoint)((ProjectFactory)this._getFactory()).getProjectDataTypeExtensionPoint(), (ModifiableRepositoryData)repositoryData);
    }

    public ActivityHolder getActivityHolder() throws RepositoryException {
        return new DefaultActivityHolder((ModifiableTraversableAmetysObject)this.getChild("ametys-internal:activities"), (DefaultActivityHolderFactory)this._getFactory());
    }

    public String getTitle() throws AmetysRepositoryException {
        return (String)this.getValue(__DATA_TITLE);
    }

    public void setTitle(String title) throws AmetysRepositoryException {
        this.setValue(__DATA_TITLE, title);
    }

    public String getDescription() throws AmetysRepositoryException {
        return (String)this.getValue(__DATA_DESCRIPTION);
    }

    public void setDescription(String description) throws AmetysRepositoryException {
        this.setValue(__DATA_DESCRIPTION, description);
    }

    public void removeDescription() throws AmetysRepositoryException {
        this.removeValue(__DATA_DESCRIPTION);
    }

    public ExplorerNode getExplorerRootNode() throws AmetysRepositoryException {
        return (ExplorerNode)this.getChild(__EXPLORER_NODE_NAME);
    }

    public AmetysObjectIterable<ExplorerNode> getExplorerNodes() throws AmetysRepositoryException {
        return ((TraversableAmetysObject)this.getChild(__EXPLORER_NODE_NAME)).getChildren();
    }

    public String getMailingList() throws AmetysRepositoryException {
        return (String)this.getValue(__DATA_MAILING_LIST);
    }

    public void setMailingList(String mailingList) throws AmetysRepositoryException {
        this.setValue(__DATA_MAILING_LIST, mailingList);
    }

    public void removeMailingList() throws AmetysRepositoryException {
        this.removeValue(__DATA_MAILING_LIST);
    }

    public ZonedDateTime getCreationDate() throws AmetysRepositoryException {
        return (ZonedDateTime)this.getValue(__DATA_CREATION);
    }

    public void setCreationDate(ZonedDateTime creationDate) throws AmetysRepositoryException {
        this.setValue(__DATA_CREATION, creationDate);
    }

    public Site getSite() {
        try {
            SiteManager siteManager = ((ProjectFactory)this._getFactory())._getSiteManager();
            Property weakReference = this.getNode().getProperty("ametys:site");
            String siteName = weakReference.getNode().getName();
            return siteManager.getSite(siteName);
        }
        catch (PathNotFoundException e) {
            ((ProjectFactory)this._getFactory()).getFactoryLogger().debug("Can not found site attribute for project " + this.getName(), (Throwable)e);
            return null;
        }
        catch (ItemNotFoundException e) {
            ((ProjectFactory)this._getFactory()).getFactoryLogger().debug("Can not found site reference for project " + this.getName(), (Throwable)e);
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unexpected repository exception", (Throwable)e);
        }
    }

    public void setSite(Site site) {
        try {
            Node projectNode = this.getNode();
            if (projectNode.hasProperty("ametys:site")) {
                this.removeValue(DATA_SITE);
            }
            ValueFactory valueFactory = projectNode.getSession().getValueFactory();
            Value weakRefValue = valueFactory.createValue(site.getNode(), true);
            projectNode.setProperty("ametys:site", weakRefValue);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unexpected repository exception", (Throwable)e);
        }
        if (this.needsSave()) {
            this.saveChanges();
        }
    }

    public UserIdentity[] getManagers() {
        return (UserIdentity[])this.getValue(__DATA_MANAGERS, new UserIdentity[0]);
    }

    public void setManagers(UserIdentity[] user) {
        this.setValue(__DATA_MANAGERS, user);
    }

    public String[] getModules() {
        return (String[])this.getValue(__DATA_MODULES, new String[0]);
    }

    public void setModules(String[] modules) {
        this.setValue(__DATA_MODULES, modules);
    }

    public void addModule(String moduleId) {
        Object[] modules = (String[])this.getValue(__DATA_MODULES);
        if (!ArrayUtils.contains((Object[])modules, (Object)moduleId)) {
            Object[] objectArray;
            if (modules == null) {
                String[] stringArray = new String[1];
                objectArray = stringArray;
                stringArray[0] = moduleId;
            } else {
                objectArray = ArrayUtils.add((Object[])modules, (Object)moduleId);
            }
            this.setValue(__DATA_MODULES, objectArray);
        }
    }

    public void removeModule(String moduleId) {
        Object[] modules = (String[])this.getValue(__DATA_MODULES);
        if (ArrayUtils.contains((Object[])modules, (Object)moduleId)) {
            this.setValue(__DATA_MODULES, ArrayUtils.removeElement((Object[])modules, (Object)moduleId));
        }
    }

    public InscriptionStatus getInscriptionStatus() {
        if (this.hasValue(__DATA_INSCRIPTION_STATUS)) {
            return InscriptionStatus.createsFromString((String)this.getValue(__DATA_INSCRIPTION_STATUS));
        }
        return InscriptionStatus.PRIVATE;
    }

    public void setInscriptionStatus(String inscriptionStatus) {
        if (inscriptionStatus != null && InscriptionStatus.createsFromString(inscriptionStatus) != null) {
            this.setValue(__DATA_INSCRIPTION_STATUS, inscriptionStatus);
        } else {
            this.removeValue(__DATA_INSCRIPTION_STATUS);
        }
    }

    public void setInscriptionStatus(InscriptionStatus inscriptionStatus) {
        if (inscriptionStatus != null) {
            this.setValue(__DATA_INSCRIPTION_STATUS, inscriptionStatus.toString());
        } else {
            this.removeValue(__DATA_INSCRIPTION_STATUS);
        }
    }

    public String getDefaultProfile() {
        return (String)this.getValue(__DATA_DEFAULT_PROFILE);
    }

    public void setDefaultProfile(String profileId) {
        if (profileId != null) {
            this.setValue(__DATA_DEFAULT_PROFILE, profileId);
        } else {
            this.removeValue(__DATA_DEFAULT_PROFILE);
        }
    }

    public ModifiableTraversableAmetysObject getRootPlugins() throws AmetysRepositoryException {
        return (ModifiableTraversableAmetysObject)this.getChild(__PLUGINS_NODE_NAME);
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return TaggableAmetysObjectHelper.getTags((JCRAmetysObject)this);
    }

    public void tag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.tag((JCRAmetysObject)this, (String)tag);
    }

    public void untag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.untag((JCRAmetysObject)this, (String)tag);
    }

    public void setTags(List<String> tags) {
        Set<String> currentTags = this.getTags();
        currentTags.stream().filter(tag -> !tags.contains(tag)).forEach(tag -> this.untag((String)tag));
        tags.stream().filter(tag -> !currentTags.contains(tag)).forEach(tag -> this.tag((String)tag));
    }

    public Set<String> getCategories() throws AmetysRepositoryException {
        return TaggableAmetysObjectHelper.getTags((JCRAmetysObject)this, (String)__DATA_CATEGORIES);
    }

    public void addCategory(String category) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.tag((JCRAmetysObject)this, (String)category, (String)__DATA_CATEGORIES);
    }

    public void removeCategory(String category) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.untag((JCRAmetysObject)this, (String)category, (String)__DATA_CATEGORIES);
    }

    public void setCategoryTags(List<String> categoryTags) {
        Set<String> currentCategories = this.getCategories();
        currentCategories.stream().filter(category -> !categoryTags.contains(category)).forEach(category -> this.removeCategory((String)category));
        categoryTags.stream().filter(category -> !currentCategories.contains(category)).forEach(category -> this.addCategory((String)category));
    }

    public void setCoverImage(InputStream is, String mimeType, String filename, ZonedDateTime lastModificationDate) throws IOException {
        if (is != null) {
            Binary coverImage = new Binary();
            coverImage.setInputStream(is);
            Optional.ofNullable(mimeType).ifPresent(arg_0 -> ((Binary)coverImage).setMimeType(arg_0));
            Optional.ofNullable(filename).ifPresent(arg_0 -> ((Binary)coverImage).setFilename(arg_0));
            Optional.ofNullable(lastModificationDate).ifPresent(arg_0 -> ((Binary)coverImage).setLastModificationDate(arg_0));
            this.setValue(__DATA_COVERIMAGE, coverImage);
        } else {
            this.removeValue(__DATA_COVERIMAGE);
        }
    }

    public Binary getCoverImage() {
        return (Binary)this.getValue(__DATA_COVERIMAGE);
    }

    public void coverImageToSAX(ContentHandler contentHandler) throws SAXException, IOException {
        this.dataToSAX(contentHandler, __DATA_COVERIMAGE);
    }

    public String[] getKeywords() {
        return (String[])this.getValue(__DATA_KEYWORDS, new String[0]);
    }

    public void setKeywords(String[] keywords) {
        this.setValue(__DATA_KEYWORDS, keywords);
    }

    public static enum InscriptionStatus {
        OPEN("open"),
        MODERATED("moderated"),
        PRIVATE("private");

        private String _value;

        private InscriptionStatus(String value) {
            this._value = value;
        }

        public String toString() {
            return this._value;
        }

        public static InscriptionStatus createsFromString(String status) {
            for (InscriptionStatus v : InscriptionStatus.values()) {
                if (!v.toString().equals(status)) continue;
                return v;
            }
            return null;
        }
    }
}

