/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.rights.accesscontroller;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.AllowedUsers;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightsException;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractRightBasedAccessController;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.report.ReportHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.rights.PageAccessController;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.codec.binary.StringUtils;

public class ReportsPageAccessController
extends AbstractRightBasedAccessController
implements Serviceable {
    protected ReportHelper _reportHelper;
    protected AmetysObjectResolver _resolver;
    protected ProjectManager _projectManager;
    protected RightsExtensionPoint _rightEP;
    private RightManager _rightManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._reportHelper = (ReportHelper)manager.lookup(ReportHelper.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._rightEP = (RightsExtensionPoint)manager.lookup(RightsExtensionPoint.ROLE);
    }

    public boolean supports(Object object) {
        return object instanceof Page && this.isReportPage((Page)object);
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        if (this._reportHelper.hasSuperRight(user) || this._projectManager.isManager(user)) {
            return AccessController.AccessResult.USER_ALLOWED;
        }
        return AccessController.AccessResult.USER_DENIED;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.ANONYMOUS_DENIED;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.ANY_CONNECTED_DENIED;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> results = new HashMap<UserIdentity, AccessController.AccessResult>();
        AllowedUsers allowedUsers = this._rightManager.getAllowedUsers("Workspaces_Reports_Right_Report_All", (Object)"/cms");
        for (UserIdentity user : allowedUsers.getAllowedUsers()) {
            results.put(user, AccessController.AccessResult.USER_ALLOWED);
        }
        Set<UserIdentity> managers = this._projectManager.getManagers();
        for (UserIdentity manager : managers) {
            results.put(manager, AccessController.AccessResult.USER_ALLOWED);
        }
        return results;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        HashMap<GroupIdentity, AccessController.AccessResult> results = new HashMap<GroupIdentity, AccessController.AccessResult>();
        AllowedUsers allowedUsers = this._rightManager.getAllowedUsers("Workspaces_Reports_Right_Report_All", (Object)"/cms");
        for (GroupIdentity group : allowedUsers.getAllowedGroups()) {
            results.put(group, AccessController.AccessResult.GROUP_ALLOWED);
        }
        return results;
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return Map.of();
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    protected AccessExplanation _getAccessExplanation(AccessController.AccessResult result, Object object, UserIdentity user, Set<GroupIdentity> groups, String rightId) {
        switch (result) {
            case USER_ALLOWED: {
                StringBuilder i18nKey = new StringBuilder("PLUGINS_WORKSPACES_REPORT_PAGE_ACCESS_CONTROLLER_");
                if (this._reportHelper.hasSuperRight(user)) {
                    i18nKey.append("HAS_RIGHT_");
                    if (this._projectManager.isManager(user)) {
                        i18nKey.append("AND_MANAGER_");
                    }
                    i18nKey.append("_EXPLANATION");
                } else {
                    i18nKey.append("MANAGER_EXPLANATION");
                }
                return new AccessExplanation(this.getId(), AccessController.AccessResult.USER_ALLOWED, new I18nizableText("plugin.workspaces", i18nKey.toString(), Map.of("right", this._rightEP.getExtension("Workspaces_Reports_Right_Report_All").getLabel(), "page", this.getObjectLabel(object))));
            }
            case USER_DENIED: {
                return new AccessExplanation(this.getId(), AccessController.AccessResult.USER_DENIED, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_REPORT_PAGE_ACCESS_CONTROLLER_DENIED_EXPLANATION", Map.of("right", this._rightEP.getExtension("Workspaces_Reports_Right_Report_All").getLabel(), "page", this.getObjectLabel(object))));
            }
            case ANONYMOUS_DENIED: {
                return new AccessExplanation(this.getId(), AccessController.AccessResult.ANONYMOUS_DENIED, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_REPORT_PAGE_ACCESS_CONTROLLER_DENIED_EXPLANATION", Map.of("right", this._rightEP.getExtension("Workspaces_Reports_Right_Report_All").getLabel(), "page", this.getObjectLabel(object))));
            }
            case ANY_CONNECTED_DENIED: {
                return new AccessExplanation(this.getId(), AccessController.AccessResult.ANY_CONNECTED_DENIED, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_REPORT_PAGE_ACCESS_CONTROLLER_DENIED_EXPLANATION", Map.of("right", this._rightEP.getExtension("Workspaces_Reports_Right_Report_All").getLabel(), "page", this.getObjectLabel(object))));
            }
            case UNKNOWN: {
                return new AccessExplanation(this.getId(), AccessController.AccessResult.UNKNOWN, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_REPORT_PAGE_ACCESS_CONTROLLER_UNKNOWN_EXPLANATION", Map.of("page", this.getObjectLabel(object))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)result);
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        return Map.of();
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return Map.of();
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    protected boolean isReportPage(Page page) {
        block8: {
            boolean bl;
            block9: {
                if (!page.getSiteName().equals(this._projectManager.getCatalogSiteName()) || Page.PageType.CONTAINER != page.getType() || !page.hasZone("default")) break block8;
                AmetysObjectIterable zoneItems = page.getZone("default").getZoneItems();
                try {
                    ZoneItem cZoneItem = zoneItems.stream().filter(z -> z.getType() == ZoneItem.ZoneType.SERVICE).filter(z -> z.getServiceId().equals("org.ametys.plugins.workspacesReports.service.Report")).findFirst().orElse(null);
                    boolean bl2 = bl = cZoneItem != null;
                    if (zoneItems == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (zoneItems != null) {
                            try {
                                zoneItems.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ProjectManager.UnknownCatalogSiteException unknownCatalogSiteException) {
                        // empty catch block
                    }
                }
                zoneItems.close();
            }
            return bl;
        }
        return false;
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Page) {
            Page page = (Page)object;
            return new I18nizableText(PageAccessController.getPageObjectLabel((Page)page));
        }
        throw new RightsException("Unsupported context: " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return PageAccessController.PAGE_CONTEXT_CATEGORY;
    }

    protected Iterable<? extends Object> getHandledObjects(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        try {
            if (StringUtils.equals((CharSequence)siteName, (CharSequence)this._projectManager.getCatalogSiteName())) {
                StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, siteName);
                Expression reportService = () -> "ametys-internal:zones/default/ametys-internal:zoneItems/ametys:zoneItem/@ametys-internal:service = 'org.ametys.plugins.workspacesReports.service.Report'";
                String query = QueryHelper.getXPathQuery(null, (String)"ametys:page", (Expression)new AndExpression(new Expression[]{siteExpr, reportService}));
                return this._resolver.query(query);
            }
        }
        catch (ProjectManager.UnknownCatalogSiteException unknownCatalogSiteException) {
            // empty catch block
        }
        return List.of();
    }

    protected Collection<String> getHandledRights() {
        return List.of();
    }
}

