/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.util.HashSet;
import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.SortOrder;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.ContentLanguageQuery;
import org.ametys.cms.search.query.FullTextQuery;
import org.ametys.cms.search.query.JoinQuery;
import org.ametys.cms.search.query.MatchAllQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.module.AbstractContentSolrSearchModuleGenerator;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MemberSearchModuleGenerator
extends AbstractContentSolrSearchModuleGenerator {
    @Override
    protected ContentSearcherFactory.SimpleContentSearcher getSearcher() {
        return this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.member"});
    }

    @Override
    protected String getSortFieldName() {
        return "lastname";
    }

    @Override
    protected SortOrder getSortOrder() {
        return SortOrder.ASC;
    }

    @Override
    protected Query getQuery(String siteName, String lang, String textfield, Request request) {
        HashSet<Object> queries = new HashSet<Object>();
        queries.add(this.getProjectQuery(request));
        queries.add(new ContentLanguageQuery(lang));
        if (StringUtils.isNotBlank((CharSequence)textfield)) {
            StringQuery titleQuery = new StringQuery("title", Query.Operator.SEARCH, textfield.trim(), lang);
            FullTextQuery fullTextQuery = new FullTextQuery(textfield.trim(), "full", lang, Query.Operator.SEARCH);
            JoinQuery skillsQuery = new JoinQuery((Query)fullTextQuery, new String[]{"skills"});
            JoinQuery keywordsQuery = new JoinQuery((Query)fullTextQuery, new String[]{"keywords"});
            OrQuery orQuery = new OrQuery(new Query[]{titleQuery, fullTextQuery, skillsQuery, keywordsQuery});
            queries.add(orQuery);
        }
        Object fullQuery = !queries.isEmpty() ? new AndQuery(queries) : new MatchAllQuery();
        return fullQuery;
    }

    @Override
    protected void saxPage(Content content) throws SAXException {
        String userPageId = UserXSLTHelper.getUserPage((String)content.getId(), (String)this._projectManager.getCatalogSiteName());
        if (userPageId != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"page", (String)userPageId);
        }
    }

    protected Query getProjectQuery(Request request) {
        List<Project> projects = this.getProjects(request, false);
        Query projectQuery = (Query)projects.stream().map(SimpleAmetysObject::getId).map(id -> new StringQuery("workspace-projectId", Query.Operator.EQ, id, null)).collect(OrQuery.collector());
        return projectQuery;
    }
}

