/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.time.LocalDate;
import java.util.List;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.FullTextExpression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.module.AbstractXpathSearchModuleGenerator;
import org.ametys.plugins.workspaces.tasks.Task;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class TaskSearchModuleGenerator
extends AbstractXpathSearchModuleGenerator {
    protected TasksWorkspaceModule _taskModule;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)this.manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._taskModule = (TasksWorkspaceModule)moduleManagerEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
    }

    @Override
    protected String getXPathQuery(String siteName, String lang, String textfield, Request request, int offset, int limit) throws Exception {
        List<Project> projects = this.getProjects(request, true);
        List<Project> filteredProjects = this.filterProjectsForModule(projects, TasksWorkspaceModule.TASK_MODULE_ID);
        if (filteredProjects.isEmpty()) {
            return null;
        }
        String projectXPathQuery = this.getProjectXPathQuery(filteredProjects);
        Object searchQuery = "";
        if (StringUtils.isNotBlank((CharSequence)textfield)) {
            FullTextExpression labelExpr = new FullTextExpression("label", textfield);
            FullTextExpression descExpr = new FullTextExpression("description", textfield);
            OrExpression expr = new OrExpression(new Expression[]{labelExpr, descExpr});
            searchQuery = "[" + expr.build() + "]";
        }
        String jcrQuery = projectXPathQuery + "//element(*, ametys:task)" + (String)searchQuery;
        return jcrQuery;
    }

    @Override
    protected void saxHit(AmetysObject object, String lang) throws Exception {
        if (object instanceof Task) {
            Task task = (Task)object;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", task.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"hit", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)task.getLabel());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)task.getDescription());
            Project project = this.getProject(object);
            String taskUri = this._taskModule.getTaskUri(project, task.getId());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"uri", (String)taskUri);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isClosed", (String)String.valueOf(task.isClosed()));
            LocalDate endDate = task.getDueDate();
            if (endDate != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"dueDate", (String)DateUtils.localDateToString((LocalDate)endDate));
            }
            UserIdentity author = task.getAuthor();
            this.saxUser(author, "author");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"assignments");
            List<UserIdentity> assignments = task.getAssignments();
            for (UserIdentity assignment : assignments) {
                this.saxUser(assignment, "assignment");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"assignments");
            this.saxProject(project);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"hit");
        }
    }
}

