/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.suggestions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;
import org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProjectsSuggestionsGenerator
extends ServiceableGenerator {
    protected ProjectManager _projectManager;
    protected ProjectMemberManager _projectMembers;
    protected ProjectsCatalogueManager _projectCatalogManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._projectMembers = (ProjectMemberManager)((Object)smanager.lookup(ProjectMemberManager.ROLE));
        this._projectCatalogManager = (ProjectsCatalogueManager)((Object)smanager.lookup(ProjectsCatalogueManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"suggestions");
        String projectName = ProjectXsltHelper.project();
        if (StringUtils.isEmpty((CharSequence)projectName)) {
            this.getLogger().warn("There is no current project to get the project suggestions");
        } else {
            ModelAwareDataHolder serviceParameters;
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
            Long nbMax = 0L;
            if (zoneItem != null && (serviceParameters = zoneItem.getServiceParameters()) != null && serviceParameters.hasValue("maxlength")) {
                nbMax = (Long)zoneItem.getServiceParameters().getValue("maxlength");
            }
            List<Project> suggestedProjects = this.getSuggestedProjects(projectName, this._currentUserProvider.getUser(), nbMax.equals(0L) ? Integer.MAX_VALUE : nbMax.intValue());
            for (Project suggestedProject : suggestedProjects) {
                this._projectCatalogManager.saxProject(this.contentHandler, suggestedProject);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"suggestions");
        this.contentHandler.endDocument();
    }

    protected List<Project> getSuggestedProjects(String projectName, UserIdentity user, int max) {
        Project project = this._projectManager.getProject(projectName);
        if (project != null) {
            Set<String> projectCategories = project.getCategories();
            Set<String> projectKeywords = Set.of(project.getKeywords());
            List<Project> relatedProjects = this._projectManager.getProjects(projectCategories, projectKeywords, true);
            List projects = relatedProjects.stream().filter(p -> !p.getName().equals(projectName)).filter(p -> p.getInscriptionStatus() != Project.InscriptionStatus.PRIVATE).filter(p -> this._projectMembers.getProjectMember((Project)((Object)p), user) == null).filter(p -> this._projectManager.isUserInProjectPopulations((Project)((Object)p), user)).collect(Collectors.toList());
            projects.sort(new ProjectComparator(this, projectCategories, projectKeywords));
            return projects.subList(0, Integer.min(projects.size(), max));
        }
        this.getLogger().warn("Unknown project with name '" + projectName + "'");
        return List.of();
    }

    class ProjectComparator
    implements Comparator<Project> {
        private Collection<String> _baseKeywords;
        private Collection<String> _baseCategories;

        public ProjectComparator(ProjectsSuggestionsGenerator this$0, Collection<String> baseCategories, Collection<String> baseKeywords) {
            this._baseCategories = baseCategories;
            this._baseKeywords = baseKeywords;
        }

        @Override
        public int compare(Project p1, Project p2) {
            int score1 = this.countCommonCategories(p1) * 2 + this.countCommonKeywords(p1);
            int score2 = this.countCommonCategories(p2) * 2 + this.countCommonKeywords(p2);
            return score2 - score1;
        }

        int countCommonCategories(Project project) {
            Set<String> projectCategories = project.getCategories();
            if (this._baseCategories.isEmpty() || projectCategories.isEmpty()) {
                return 0;
            }
            return CollectionUtils.intersection(this._baseCategories, projectCategories).size();
        }

        int countCommonKeywords(Project project) {
            List<String> projectKeywords = Arrays.asList(project.getKeywords());
            if (this._baseKeywords.isEmpty() || projectKeywords.isEmpty()) {
                return 0;
            }
            return CollectionUtils.intersection(this._baseKeywords, projectKeywords).size();
        }
    }
}

