/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tasks.AbstractWorkspaceTaskDAO;
import org.ametys.plugins.workspaces.tasks.Task;
import org.ametys.plugins.workspaces.tasks.TasksList;
import org.ametys.plugins.workspaces.tasks.TasksListColorsComponent;
import org.ametys.plugins.workspaces.tasks.TasksListIconsComponent;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;
import org.ametys.plugins.workspaces.tasks.jcr.JCRTasksList;
import org.ametys.plugins.workspaces.tasks.json.TasksListJSONHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.collections4.MapUtils;

public class WorkspaceTasksListDAO
extends AbstractWorkspaceTaskDAO {
    public static final String ROLE = WorkspaceTasksListDAO.class.getName();
    protected TasksListJSONHelper _tasksListJSONHelper;
    protected TasksListColorsComponent _tasksListColorsComponent;
    protected TasksListIconsComponent _tasksListIconsComponent;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._tasksListJSONHelper = (TasksListJSONHelper)((Object)manager.lookup(TasksListJSONHelper.ROLE));
        this._tasksListColorsComponent = (TasksListColorsComponent)((Object)manager.lookup(TasksListColorsComponent.ROLE));
        this._tasksListIconsComponent = (TasksListIconsComponent)manager.lookup(TasksListIconsComponent.ROLE);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getTasksLists() {
        Project project = this._workspaceHelper.getProjectFromRequest();
        this._checkReadAccess(project, TasksWorkspaceModule.TASK_MODULE_ID);
        ArrayList<Map<String, Object>> tasksListsInfo = new ArrayList<Map<String, Object>>();
        for (TasksList tasksList : this._getProjectTasksLists(project)) {
            tasksListsInfo.add(this._tasksListJSONHelper.tasksListAsJson(tasksList));
        }
        return tasksListsInfo;
    }

    @Callable(rights={""})
    public Map<String, Object> addTasksList(String label) {
        Project project = this._workspaceHelper.getProjectFromRequest();
        ModifiableTraversableAmetysObject tasksRoot = this._getTasksListsRoot(project, true);
        this._checkUserRights((AmetysObject)tasksRoot, "Plugin_Workspace_Handle_Tasks_List");
        int index = 1;
        Object name = "tasks-list-1";
        while (tasksRoot.hasChild((String)name)) {
            name = "tasks-list-" + ++index;
        }
        List<TasksList> projectsTasksList = this._getProjectTasksLists(project);
        JCRTasksList tasksList = (JCRTasksList)tasksRoot.createChild((String)name, "ametys:tasks-list");
        tasksList.setListId(tasksList.getId());
        tasksList.setPosition(Long.valueOf(projectsTasksList.size()));
        tasksList.setLabel(label);
        tasksList.setColor(this._tasksListColorsComponent.getDefaultKey());
        tasksList.setIcon(this._tasksListIconsComponent.getDefaultKey());
        ZonedDateTime now = ZonedDateTime.now();
        tasksList.setCreationDate(now);
        tasksList.setLastModified(now);
        tasksList.setAuthor(this._currentUserProvider.getUser());
        tasksRoot.saveChanges();
        return this._tasksListJSONHelper.tasksListAsJson(tasksList);
    }

    @Callable(rights={""})
    public Map<String, Object> editTasksList(String tasksListId, String newLabel) {
        JCRTasksList tasksList = (JCRTasksList)this._resolver.resolveById(tasksListId);
        this._checkUserRights(tasksList.getParent(), "Plugin_Workspace_Handle_Tasks_List");
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (!newLabel.equals(tasksList.getLabel())) {
            tasksList.setLabel(newLabel);
            tasksList.setLastModified(ZonedDateTime.now());
            tasksList.saveChanges();
        }
        results.put("id", tasksList.getId());
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> deleteTasksList(String tasksListId) {
        Project project = this._workspaceHelper.getProjectFromRequest();
        TasksList taskList = (TasksList)this._resolver.resolveById(tasksListId);
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)taskList.getParent();
        this._checkUserRights((AmetysObject)tasksRoot, "Plugin_Workspace_Delete_Tasks_List");
        if (!this.getChildTask(tasksListId).isEmpty()) {
            throw new UnsupportedOperationException("Can't remove tasks list with id '" + tasksListId + "' because it is not empty");
        }
        taskList.remove();
        long position = 0L;
        for (TasksList childTasksList : this._getProjectTasksLists(project)) {
            childTasksList.setPosition(position);
            ++position;
        }
        tasksRoot.saveChanges();
        return MapUtils.EMPTY_SORTED_MAP;
    }

    @Callable(rights={""})
    public Map<String, Object> moveTasksList(String tasksListId, long newPosition) {
        Project project = this._workspaceHelper.getProjectFromRequest();
        TasksList taskList = (TasksList)this._resolver.resolveById(tasksListId);
        ModifiableTraversableAmetysObject tasksRoot = (ModifiableTraversableAmetysObject)taskList.getParent();
        this._checkUserRights((AmetysObject)tasksRoot, "Plugin_Workspace_Handle_Tasks_List");
        HashMap<String, Object> results = new HashMap<String, Object>();
        List<TasksList> childTasksLists = this._getProjectTasksLists(project);
        int size = childTasksLists.size();
        if (newPosition > (long)size) {
            throw new IllegalArgumentException("New position (" + newPosition + ") can't be greater than tasks lists size (" + size + ")");
        }
        long position = 0L;
        for (TasksList childTasksList : childTasksLists) {
            if (position == newPosition) {
                ++position;
            }
            if (childTasksList.getId().equals(tasksListId)) {
                childTasksList.setPosition(newPosition);
                continue;
            }
            childTasksList.setPosition(position);
            ++position;
        }
        tasksRoot.saveChanges();
        return results;
    }

    @Callable(rights={"*"})
    public List<Map<String, String>> getTasksListColors() {
        return this._tasksListColorsComponent.getColors().entrySet().stream().map(e -> Map.of("id", (String)e.getKey(), "color", (String)((Map)e.getValue()).get("main"))).collect(Collectors.toList());
    }

    @Callable(rights={"*"})
    public List<Map<String, String>> getTasksListIcons() {
        return this._tasksListIconsComponent.getIcons();
    }

    @Callable(rights={""})
    public Map<String, Object> updateTasksListColor(String tasksListId, String colorId) {
        JCRTasksList tasksList = (JCRTasksList)this._resolver.resolveById(tasksListId);
        this._checkUserRights(tasksList.getParent(), "Plugin_Workspace_Handle_Tasks_List");
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (!colorId.equals(tasksList.getColor())) {
            tasksList.setColor(colorId);
            tasksList.setLastModified(ZonedDateTime.now());
            tasksList.saveChanges();
        }
        results.put("id", tasksList.getId());
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> updateTasksListIcon(String tasksListId, String iconId) {
        JCRTasksList tasksList = (JCRTasksList)this._resolver.resolveById(tasksListId);
        this._checkUserRights(tasksList.getParent(), "Plugin_Workspace_Handle_Tasks_List");
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (!iconId.equals(tasksList.getIcon())) {
            tasksList.setIcon(iconId);
            tasksList.setLastModified(ZonedDateTime.now());
            tasksList.saveChanges();
        }
        results.put("id", tasksList.getId());
        return results;
    }

    protected List<TasksList> _getProjectTasksLists(Project project) {
        TasksWorkspaceModule taskModule = (TasksWorkspaceModule)this._workspaceModuleEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
        return Optional.of(project).map(p -> taskModule.getTasksListsRoot((Project)((Object)p), true)).map(TraversableAmetysObject::getChildren).map(AmetysObjectIterable::stream).orElseGet(Stream::empty).filter(TasksList.class::isInstance).map(TasksList.class::cast).sorted(Comparator.comparingLong(TasksList::getPosition)).collect(Collectors.toList());
    }

    public List<Task> getChildTask(String tasksListId) {
        String xpathQuery = "//element(*, ametys:task)[ametys:tasksListId = '" + tasksListId + "']";
        return this._resolver.query(xpathQuery).stream().filter(Task.class::isInstance).map(Task.class::cast).sorted(Comparator.comparingLong(Task::getPosition)).collect(Collectors.toList());
    }
}

