/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks.datapolicy;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workspaces.datapolicy.AbstractCommentAndReactionDataPolicy;
import org.ametys.plugins.workspaces.tasks.jcr.JCRTask;
import org.apache.commons.lang3.tuple.Pair;

public class TaskCommentAndReactionDataPolicy
extends AbstractCommentAndReactionDataPolicy {
    @Override
    protected String getLogCategory() {
        return "task";
    }

    @Override
    protected String getObjectPrimaryType() {
        return "ametys:task";
    }

    @Override
    protected boolean handleComment(Node commentNode) {
        try {
            Pair<Node, String> holderAndCommentId = this.getObjectNodeAndCommentId(commentNode);
            if (holderAndCommentId != null) {
                JCRTask task = (JCRTask)this._resolver.resolve((Node)holderAndCommentId.getLeft(), false);
                Comment comment = task.getComment((String)holderAndCommentId.getRight());
                comment.setAuthor(UserPopulationDAO.UNKNOWN_USER_IDENTITY);
                comment.setAuthorEmail(null);
                comment.setAuthorName(null);
                task.saveChanges();
                return true;
            }
        }
        catch (RepositoryException | AmetysRepositoryException e) {
            this.getLogger().error("Failed to retrieve file and comment from comment node '{}'", (Object)commentNode, (Object)e);
        }
        return false;
    }
}

