/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks.generators;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Stream;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tasks.Task;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;
import org.ametys.plugins.workspaces.tasks.WorkspaceTaskDAO;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TaskListGenerator
extends ServiceableGenerator {
    protected ProjectManager _projectManager;
    protected ProjectsCatalogueManager _projectCatalogManager;
    protected WorkspaceTaskDAO _workspaceTaskDAO;
    protected CurrentUserProvider _currentUserProvider;
    private WorkspaceModuleExtensionPoint _moduleEP;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)serviceManager.lookup(ProjectManager.ROLE));
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)serviceManager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._projectCatalogManager = (ProjectsCatalogueManager)((Object)serviceManager.lookup(ProjectsCatalogueManager.ROLE));
        this._workspaceTaskDAO = (WorkspaceTaskDAO)((Object)serviceManager.lookup(WorkspaceTaskDAO.ROLE));
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        int max = this.parameters.getParameterAsInteger("max-results", 0);
        UserIdentity currentUser = this._currentUserProvider.getUser();
        Stream<Task> streamTasks = this._projectManager.getUserProjects(currentUser).keySet().stream().map(project -> this._workspaceTaskDAO.getProjectTasks((Project)((Object)project))).flatMap(Collection::stream).filter(t -> !t.isClosed()).filter(t -> t.getAssignments().contains(currentUser)).sorted(Comparator.comparing(t -> t.getCreationDate()));
        if (max > 0) {
            streamTasks = streamTasks.limit(max);
        }
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tasks");
        streamTasks.forEach(task -> {
            Project project = this._projectManager.getParentProject((AmetysObject)task);
            this._saxTask(project, (Task)task);
        });
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tasks");
        this.contentHandler.endDocument();
    }

    protected void _saxTask(Project project, Task task) {
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", task.getId());
            String pageId = this._getTaskPageId(project);
            if (pageId != null) {
                attrs.addCDATAAttribute("pageId", pageId);
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"task", (Attributes)attrs);
            attrs.clear();
            attrs.addCDATAAttribute("id", project.getId());
            String siteUrl = this._projectManager.getProjectUrl(project, null);
            if (siteUrl != null) {
                attrs.addCDATAAttribute("url", siteUrl);
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"project", (String)project.getTitle());
            this._projectCatalogManager.saxCategory(this.contentHandler, project, "projectCategory");
            task.dataToSAX(this.contentHandler);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"task");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while gathering the tasks' information.");
        }
    }

    private String _getTaskPageId(Project project) {
        Object module = this._moduleEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
        Set<Page> taskModulePages = this._projectManager.getModulePages(project, (WorkspaceModule)module);
        if (!taskModulePages.isEmpty()) {
            return taskModulePages.iterator().next().getId();
        }
        return null;
    }
}

