/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks.jcr;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObjectHelper;
import org.ametys.plugins.workspaces.tasks.Task;
import org.ametys.plugins.workspaces.tasks.jcr.JCRTaskFactory;
import org.ametys.runtime.model.ModelItemContainer;

public class JCRTask
extends DefaultAmetysObject<JCRTaskFactory>
implements Task {
    public static final String ATTRIBUTE_TASK_ID = "id";
    public static final String ATTRIBUTE_TASKSLISTID = "tasksListId";
    public static final String ATTRIBUTE_TASKSLISTPOSITION = "tasksListPosition";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_STARTDATE = "startDate";
    public static final String ATTRIBUTE_DUEDATE = "dueDate";
    public static final String ATTRIBUTE_ISCLOSED = "isClosed";
    public static final String ATTRIBUTE_CLOSEDATE = "closeDate";
    public static final String ATTRIBUTE_CLOSEAUTHOR = "closeAuthor";
    public static final String ATTRIBUTE_AUTHOR = "author";
    public static final String ATTRIBUTE_ASSIGNMENTS = "assignments";
    public static final String ATTRIBUTE_CREATIONDATE = "creationDate";
    public static final String ATTRIBUTE_LASTMODIFIED = "lastModified";
    public static final String ATTRIBUTE_ATTACHMENTS = "attachments";
    public static final String ATTRIBUTE_CHECKLIST = "checkList";
    public static final String ATTRIBUTE_CHECKLIST_LABEL = "label";
    public static final String ATTRIBUTE_CHECKLIST_ISCHECKED = "isChecked";
    public static final String ATTRIBUTE_TAGS = "tags";

    public JCRTask(Node node, String parentPath, JCRTaskFactory factory) {
        super(node, parentPath, (DefaultAmetysObjectFactory)factory);
    }

    @Override
    public String getTaskListId() {
        return (String)this.getValue(ATTRIBUTE_TASKSLISTID);
    }

    @Override
    public void setTasksListId(String taskListId) {
        this.setValue(ATTRIBUTE_TASKSLISTID, taskListId);
    }

    @Override
    public Long getPosition() {
        return (Long)this.getValue(ATTRIBUTE_TASKSLISTPOSITION);
    }

    @Override
    public void setPosition(Long position) {
        this.setValue(ATTRIBUTE_TASKSLISTPOSITION, position);
    }

    @Override
    public String getLabel() {
        return (String)this.getValue("label");
    }

    @Override
    public void setLabel(String label) {
        this.setValue("label", label);
    }

    @Override
    public String getDescription() {
        return (String)this.getValue(ATTRIBUTE_DESCRIPTION);
    }

    @Override
    public void setDescription(String description) {
        this.setValue(ATTRIBUTE_DESCRIPTION, description);
    }

    @Override
    public LocalDate getStartDate() {
        return (LocalDate)this.getValue(ATTRIBUTE_STARTDATE);
    }

    @Override
    public void setStartDate(LocalDate startDate) {
        this.setValue(ATTRIBUTE_STARTDATE, startDate);
    }

    @Override
    public LocalDate getDueDate() {
        return (LocalDate)this.getValue(ATTRIBUTE_DUEDATE);
    }

    @Override
    public void setDueDate(LocalDate dueDate) {
        this.setValue(ATTRIBUTE_DUEDATE, dueDate);
    }

    @Override
    public boolean isClosed() {
        return (Boolean)this.getValue(ATTRIBUTE_ISCLOSED, false, false);
    }

    @Override
    public void close(boolean isClosed) {
        this.setValue(ATTRIBUTE_ISCLOSED, isClosed);
    }

    @Override
    public UserIdentity getCloseAuthor() {
        return (UserIdentity)this.getValue(ATTRIBUTE_CLOSEAUTHOR);
    }

    @Override
    public void setCloseAuthor(UserIdentity author) {
        this.setValue(ATTRIBUTE_CLOSEAUTHOR, author);
    }

    @Override
    public LocalDate getCloseDate() {
        return (LocalDate)this.getValue(ATTRIBUTE_CLOSEDATE);
    }

    @Override
    public void setCloseDate(LocalDate closedDate) {
        this.setValue(ATTRIBUTE_CLOSEDATE, closedDate);
    }

    @Override
    public UserIdentity getAuthor() {
        return (UserIdentity)this.getValue(ATTRIBUTE_AUTHOR);
    }

    @Override
    public void setAuthor(UserIdentity author) {
        this.setValue(ATTRIBUTE_AUTHOR, author);
    }

    @Override
    public List<UserIdentity> getAssignments() {
        UserIdentity[] users = (UserIdentity[])this.getValue(ATTRIBUTE_ASSIGNMENTS, false, new UserIdentity[0]);
        return Arrays.asList(users);
    }

    @Override
    public void setAssignments(List<UserIdentity> assignments) {
        this.setValue(ATTRIBUTE_ASSIGNMENTS, assignments.toArray(new UserIdentity[assignments.size()]));
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return (ZonedDateTime)this.getValue(ATTRIBUTE_CREATIONDATE);
    }

    @Override
    public void setCreationDate(ZonedDateTime creationDate) {
        this.setValue(ATTRIBUTE_CREATIONDATE, creationDate);
    }

    @Override
    public ZonedDateTime getLastModified() {
        return (ZonedDateTime)this.getValue(ATTRIBUTE_LASTMODIFIED);
    }

    @Override
    public void setLastModified(ZonedDateTime lastModifiedDate) {
        this.setValue(ATTRIBUTE_LASTMODIFIED, lastModifiedDate);
    }

    public List<Binary> getAttachments() {
        Binary[] attachements = (Binary[])this.getValue(ATTRIBUTE_ATTACHMENTS, false, new Binary[0]);
        return Arrays.asList(attachements);
    }

    public void setAttachments(List<Binary> attachments) {
        this.setValue(ATTRIBUTE_ATTACHMENTS, attachments.toArray(new Binary[attachments.size()]));
    }

    public void tag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.tag((JCRAmetysObject)this, (String)tag);
    }

    public void untag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.untag((JCRAmetysObject)this, (String)tag);
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return TaggableAmetysObjectHelper.getTags((JCRAmetysObject)this);
    }

    @Override
    public List<Task.CheckItem> getCheckList() {
        ModifiableIndexableRepeater repeater = this.getRepeater(ATTRIBUTE_CHECKLIST, true);
        return repeater.getEntries().stream().map(e -> new Task.CheckItem((String)e.getValue("label"), (Boolean)e.getValue(ATTRIBUTE_CHECKLIST_ISCHECKED, false, (Object)false))).collect(Collectors.toList());
    }

    @Override
    public void setCheckListItem(List<Task.CheckItem> checkItems) {
        ModifiableIndexableRepeater repeater = this.getRepeater(ATTRIBUTE_CHECKLIST, true);
        for (ModifiableModelAwareRepeaterEntry entry : repeater.getEntries()) {
            repeater.removeEntry(entry.getPosition());
        }
        for (Task.CheckItem checkItem : checkItems) {
            ModifiableModelAwareRepeaterEntry entry = repeater.addEntry();
            entry.setValue("label", (Object)checkItem.getLabel());
            entry.setValue(ATTRIBUTE_CHECKLIST_ISCHECKED, (Object)checkItem.isChecked());
        }
    }

    private ModifiableModelLessDataHolder _getCommentsDataHolder() {
        try {
            Node commentsNode;
            Node baseNode = this.getBaseNode();
            if (!baseNode.hasNode("ametys:comments")) {
                baseNode.addNode("ametys:comments", "ametys:compositeMetadata");
            }
            if (!(commentsNode = baseNode.getNode("ametys:comments")).hasNode("ametys:comments")) {
                commentsNode.addNode("ametys:comments", "ametys:compositeMetadata");
            }
            Node secondLevelCommentsNode = commentsNode.getNode("ametys:comments");
            baseNode.getSession().save();
            JCRRepositoryData repositoryData = new JCRRepositoryData(secondLevelCommentsNode);
            return new DefaultModifiableModelLessDataHolder(((JCRTaskFactory)this._getFactory()).getUnversionedDataTypeExtensionPoint(), (ModifiableRepositoryData)repositoryData);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }

    public Comment createComment() {
        return new Comment(this._getCommentsDataHolder());
    }

    public Comment createComment(String commentId, ZonedDateTime creationDate) {
        return new Comment(this._getCommentsDataHolder(), commentId, creationDate);
    }

    public Comment getComment(String commentId) throws AmetysRepositoryException {
        return Comment.getComment((ModifiableModelLessDataHolder)this._getCommentsDataHolder(), (String)commentId);
    }

    public List<Comment> getComments(boolean includeNotValidatedComments, boolean includeValidatedComments) throws AmetysRepositoryException {
        return Comment.getComments((ModifiableModelLessDataHolder)this._getCommentsDataHolder(), (boolean)includeNotValidatedComments, (boolean)includeValidatedComments);
    }

    public ModifiableIndexableDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelAwareDataHolder((ModifiableRepositoryData)repositoryData, (ModelItemContainer)((JCRTaskFactory)this._getFactory()).getTaskModel());
    }
}

