/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let projectManager = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.ProjectManager.ROLE);
let workspaceModuleExtensionPoint = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint.ROLE);
  let calendarModule = workspaceModuleExtensionPoint.getModule("org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule");
  projectManager.getProjects().forEach(
    project =>
    {
        migrateProjectCalendar(project, Repository.session);
        let liveProject = Repository.resolver.resolveById(project.getId(), Repository.liveSession);
        migrateProjectCalendar(liveProject, Repository.liveSession);
        let resourceCalendar = calendarModule.createResourceCalendar(project, {});
        const resourceCalendarNode = resourceCalendar.getNode()
        if (!Repository.liveSession.getRootNode().hasNode(resourceCalendarNode.getPath().substring(1))) 
        {
            /* No data in live */
            const SynchronizeComponent = Ametys.serviceManager.lookup(org.ametys.web.synchronization.SynchronizeComponent.ROLE)
            const parentNode = SynchronizeComponent.cloneAncestorsAndPreserveUUID(resourceCalendarNode, Repository.liveSession);
            const liveResourceCalendarNode = SynchronizeComponent.addNodeWithUUID(resourceCalendarNode, parentNode, resourceCalendarNode.getName())
            SynchronizeComponent.cloneNodeAndPreserveUUID(resourceCalendarNode, liveResourceCalendarNode, org.apache.commons.collections.PredicateUtils.truePredicate(), org.ametys.cms.support.AmetysPredicateUtils.ametysAttributePredicate())
            Repository.liveSession.save()
        }
    }
);

function migrateProjectCalendar(project, currentSession)
{
  let calendarsRoot = calendarModule.getCalendarsRoot(project, true)
  calendarModule.getModuleRoot(project, false).getChildren().forEach(
    child =>
    {
        if(child.getClass().getName() == "org.ametys.plugins.workspaces.calendars.jcr.JCRCalendar")
        {
            currentSession.move(child.getNode().getPath(), calendarsRoot.getNode().getPath() + "/" + child.getName());
        }
    });
   currentSession.save()
}

let tagsEP = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint.ROLE);
  
let count = 0;
let allTags = _getAllTagsName();
projectManager.getProjects().forEach(
    project =>
    {   
        count = 0;     
        logger.info("[Default] Start migrating keywords for resources in project " + project.getName())
        let root = calendarModule.getCalendarsRoot(project, false)
         
        if (root != null)
        {
            root.getChildren().forEach(
                calendars =>
                {
                    calendars.getChildren().forEach(
                        event =>
                        {
                            if(event.getClass().getName() == "org.ametys.plugins.workspaces.calendars.jcr.JCRCalendarEvent")
                            {
                                _migrateKeywords(event);
                            }
                        }); 
                });
    
            try 
            {
                count = 0;     
                logger.info("[Live] Start migrating keywords for resources in project " + project.getName())
                let rootLive = Repository.resolver.resolveById(root.getId(), Repository.liveSession);
                rootLive.getChildren().forEach(
                        calendars =>
                        {
                            calendars.getChildren().forEach(
                                event =>
                                {
                                    if(event.getClass().getName() == "org.ametys.plugins.workspaces.calendars.jcr.JCRCalendarEvent")
                                    {
                                        _migrateKeywords(event);
                                    }
                                }); 
                        });
                logger.info("[Live] " + count  + " resources migrated");
            }
            catch (e) {/* No data in live */}
        }
    }
);
  
function _migrateKeywords(event)
{
    let hasChanges = false;
    let eventKeywords = []
    if (event.getNode().hasProperty("ametys:keywords"))
    {
        let values = event.getNode().getProperty("ametys:keywords").getValues();
        for (i = 0; i < values.length; i++)
        {
            eventKeywords[i] = values[i].getString();
        }
    }
    
    for (let keyword of eventKeywords)
    {
       let filteredName = java.text.Normalizer.normalize(keyword.toLowerCase(), java.text.Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").trim(); 
       let tagName = filteredName.replaceAll("œ", "oe").replaceAll("æ", "ae").replaceAll("[^a-z0-9]", "_").replaceAll("_+", "_").toUpperCase();
       if (_hasTag(tagName))
       {
          event.tag(tagName);
          hasChanges = true;
       }
       else
       {
          _addTag(tagName, keyword);
          event.tag(tagName);
          hasChanges = true;
          logger.info("Creating project tag " + keyword);
       }
    }
    
    if (event.getNode().hasProperty("ametys:keywords"))
    {
        event.getNode().getProperty("ametys:keywords").remove();
        hasChanges = true;
    }
    
    if (hasChanges)
    {
        event.saveChanges();
        count++;
    }
}

function _hasTag(tagName)
{
    return allTags.indexOf(tagName) != -1;
}

function _getAllTagsName()
{
    let provider = tagsEP.getExtension("org.ametys.plugins.workspaces.tags.ProjectJCRTagProvider"); 
    let rootTag = provider.getRootNode(null);
    
    return _getTagsName(rootTag);
}
  
function _getTagsName(rootTag)
{
    let tagNames = [];
    for (let child of rootTag.getChildren())
    {
        if (child instanceof org.ametys.plugins.workspaces.tags.ProjectTagJCR)
        {
            tagNames.push(child.getName());
            for (let childTagName of _getTagsName(child))
            {
                tagNames.push(childTagName);
            }
        }
    }
    return tagNames;
}

function _addTag(tagName, tagTitle)
{
    let provider = tagsEP.getExtension("org.ametys.plugins.workspaces.tags.ProjectJCRTagProvider"); 
    let rootTag = provider.getRootNode(null);
    
    let jcrTag = rootTag.createChild(tagName, org.ametys.plugins.workspaces.tags.ProjectTagFactory.TAG_NODETYPE);
    jcrTag.setTitle(tagTitle);
    jcrTag.setDescription("");
    
    allTags.push(tagName);
        
    rootTag.saveChanges();
}

