/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const PageType = Java.type("org.ametys.web.repository.page.Page.PageType");
const ZoneType = Java.type("org.ametys.web.repository.page.ZoneItem.ZoneType");
const SynchronizeComponent = Ametys.serviceManager.lookup(org.ametys.web.synchronization.SynchronizeComponent.ROLE);
const SkinsManager = Ametys.serviceManager.lookup(org.ametys.web.skin.SkinsManager.ROLE);

let count = 0;

function migrateNewsRootPage(page)
{    
    if (page.getType().name() == "NODE")
    {
        page.setType(PageType.CONTAINER);
        page.setTemplate("news");
        
        let zone = page.createZone("default");
        let zoneItem = zone.addZoneItem();
        zoneItem.setType(ZoneType.SERVICE);
        zoneItem.setServiceId("org.ametys.web.service.SearchService");
        
        var serviceParameters = zoneItem.getServiceParameters();
        
        var paramsNode = zoneItem.getNode().getNode('ametys:service_parameters');
        Repository.helper.setProperty(paramsNode, "ametys:contentTypes", ['org.ametys.plugins.workspaces.Content.projectNews']);
        Repository.helper.setProperty(paramsNode, "ametys:returnables", ['org.ametys.web.frontoffice.search.metamodel.impl.ContentReturnable']);
        Repository.helper.setProperty(paramsNode, "ametys:initialSorts", ['{"name":"ContentReturnable$ContentSearchable$indexingField$org.ametys.plugins.workspaces.Content.abstractNews$start-date","sort":"DESC"}', '{"name":"ContentReturnable$ContentSearchable$indexingField$org.ametys.plugins.workspaces.Content.abstractNews$end-date","sort":"DESC"}']);
        Repository.helper.setProperty(paramsNode, "ametys:contexts", ['{"sites":"{\\"context\\":\\"CURRENT_SITE\\",\\"sites\\":[]}","search-sitemap-context":"{\\"context\\\":\\\"CURRENT_SITE\\",\\\"page\\\":null}","context-lang":"CURRENT","tags":[]}']);
        paramsNode.setProperty("ametys:resultsPerPage", 12);
        paramsNode.setProperty("ametys:rightCheckingMode", "exact");
        paramsNode.setProperty("ametys:resultPlace", "ABOVE_CRITERIA");
        paramsNode.setProperty("ametys:launchSearchAtStartup", true);
        paramsNode.setProperty("ametys:rss", false);
        paramsNode.setProperty("ametys:contentView", "portlet");
        paramsNode.setProperty("ametys:xslt", 'pages/services/search/project-news.xsl');
        
        // synchronize page in live session
        let skin = SkinsManager.getSkin(page.getSite().getSkinId());
        SynchronizeComponent.synchronizePage(page, skin, Repository.liveSession);
        
        count++;
    }
}

function migrateNewsRootPages(session)
{
    count=0;
    Repository.query("//element(*, ametys:site)[@ametys:type='workspaces.project']//element(news, ametys:page)", true, session).forEach(function(page) {
        migrateNewsRootPage(page);
    });
    
    session.save();
    Repository.liveSession.save();
    
    logger.info(`${count} project news pages(s) have been migrated`);
}
   
migrateNewsRootPages(Repository.session);

