/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
let config = org.ametys.runtime.config.Config.getInstance();
let rightDataBaseId = config.getValue('runtime.rights.datasource');
let rights = {};
  
let rs = SQL.query("SELECT * FROM Rights_ProfileRights", rightDataBaseId);
while (rs.next())
{
    let profile = rs.getString("Profile_Id");
    if (!rights[profile])
    {
        rights[profile] = [];
    }
    let rightId = rs.getString("Right_Id");
    rights[profile].push(rightId);
}
  
for (let profile in rights)
{
   let rightIds = rights[profile];
    
   deleteIfExist(profile, rightIds, "Plugin_Explorer_Task_View");
    
   let hasAddTaskRight = deleteIfExist(profile, rightIds, "Plugin_Explorer_Task_Add");
   let hasEditTaskRight = deleteIfExist(profile, rightIds, "Plugin_Explorer_Task_Edit");
    
   let hasDeleteTaskRight = deleteIfExist(profile, rightIds, "Plugin_Explorer_Task_Delete");
   let hasDeleteAllTaskRight = deleteIfExist(profile, rightIds, "Plugin_Explorer_Task_Delete_All");
     
   if (hasAddTaskRight || hasEditTaskRight)
   {
       insertRight(profile, "Plugin_Workspace_Handle_Tasks_List");
       insertRight(profile, "Plugin_Workspace_Handle_Task");
       insertRight(profile, "Plugin_Workspace_Comment_Task");
   }
    
   if (hasDeleteTaskRight || hasDeleteAllTaskRight)
   {
       insertRight(profile, "Plugin_Workspace_Delete_Tasks_List");
       insertRight(profile, "Plugin_Workspace_Delete_Task");
   }
}
  
function deleteIfExist(profile, rightIds, rightId)
{
   if (rightIds.indexOf(rightId) != -1)
   {
       let nbChanges = SQL.update("DELETE FROM Rights_ProfileRights "
              + "WHERE Profile_Id='" + profile + "' "
              + "AND Right_Id='" + rightId + "'",
       rightDataBaseId);
       
       logger.info("Delete right '" + rightId + "' for profile '" + profile + "'");
       return nbChanges > 0;
   }
    
   return false;
}
  
function insertRight(profile, rightId)
{
   SQL.update("INSERT INTO Rights_ProfileRights "
            + "VALUES ('" + profile + "','" + rightId + "')",
   rightDataBaseId); 
    
   logger.info("Add right '" + rightId + "' for profile '" + profile + "'");
}
