/*

 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This factory creates Ametys.message.MessageTarget for a page.
 * 
 * See #createTargets to know more.
 * @private
 */
Ext.define("Ametys.plugins.workspaces.project.ProjectMessageTargetFactory",
	{
		extend: "Ametys.message.factory.DefaultMessageTargetFactory",

		/**
		 * Create the targets for a message
		 * @param {Object} parameters The parameters needed by the factory to create the message. Can not be null. Handled elements are
		 * @param {String[]} parameters.id The project's identifier. Must be present if project is empty
		 * @param {Ametys.plugins.workspaces.project.Project[]} parameters.project The project itself. Must be present if id is empty
		 * @param {Function} callback The callback function called when the target is created. Parameters are
		 * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
		 */
		createTargets: function(parameters, callback)
		{
			var targets = [];
			
			if (parameters.id)
			{
				Ametys.plugins.workspaces.project.ProjectDAO.getProject (parameters.id, Ext.bind(this._createTargets, this, [callback, parameters], true));
			}
			else if (parameters.project)
			{
				this._createTargets (parameters.project, callback, parameters);
			}
		},

		/**
		 * Create the project target
		 * @param {Ametys.plugins.workspaces.project.Project} project The project
		 * @param {Function} callback The callback function called when the targets are created. Parameters are
		 * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
		 * @param {Object} parameters The initial parameters of the #createTargets method
		 * @private
		 */
		_createTargets: function (project, callback, parameters)
		{
			delete parameters['id'];
			delete parameters['project'];
			
			var target = Ext.create("Ametys.message.MessageTarget", {
				id: Ametys.message.MessageTarget.WORKSPACES_PROJECT,
				parameters: project.getProperties(parameters)
			});
			
			callback([target]);
		}
	}
);

Ext.define('Ametys.plugins.workspaces.project.ProjectMessageTarget', {
    override: 'Ametys.message.MessageTarget',
    statics: {
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {String} WORKSPACES_PROJECT The target type is a project workspace. See Ametys.plugins.workspaces.project.ProjectMessageTargetFactory parameters to know more of the associated parameters. 
         */
    	WORKSPACES_PROJECT: 'workspaces-project',
        
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {String} WORKSPACES_PROJECTS_ROOT The target type is the root of the projects 
         */
    	WORKSPACES_PROJECTS_ROOT: 'workspaces-projects-root'
    }
});

