/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * @private
 * Singleton class defining the actions related to the super user
 */
Ext.define('Ametys.plugins.workspaces.project.actions.SuperUserActions', {
	singleton: true,
	
	/**
	 * Grant all privileges to a user on site context
	 * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
	 */
	act: function (controller)
	{
		var target = controller.getMatchingTargets()[0];
        if (target)
        {
        	if (!target.getParameters().valid)
    		{
        		Ametys.Msg.show({
                    title: "{{i18n PLUGINS_WORKSPACES_PROJECT_AFFECT_SUPERUSER_ERROR}}",
                    message: "{{i18n PLUGINS_WORKSPACES_PROJECT_AFFECT_SUPERUSER_ERROR_NOT_VALID}}",
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.ERROR
                });
        		return;
    		}
        	
        	var siteName = target.getParameters().siteName;
    		if (!siteName)
    		{
    			 Ametys.Msg.show({
                     title: "{{i18n PLUGINS_WORKSPACES_PROJECT_AFFECT_SUPERUSER_ERROR}}",
                     message: "{{i18n PLUGINS_WORKSPACES_PROJECT_AFFECT_SUPERUSER_ERROR_SITE_NOT_FOUND}}",
                     buttons: Ext.Msg.OK,
                     icon: Ext.Msg.ERROR
                 });
    			 return;
    		}
    		
    		Ametys.plugins.admin.superuser.SuperUserActions.affectSuperUser (controller, ["/sites/" + siteName], {
                siteName: siteName,
                projectName: target.getParameters().name
            });
        }
	}
	
});
