/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for nodes of a tags tree.
 * @private
 */
Ext.define('Ametys.plugins.workspaces.project.category.CategoryNode', {
    extend : 'Ext.data.Model',

    fields : [ 'id',
               'name',
               'title',
               'description',
               'color',
               'class',
               {
                   name : 'text',
                   depends: ['title'],
                   calculate: function (data)
            	   {
                	   return data.title;
            	   }
               },
               {
            	   name: 'iconCls',
            	   depends: ['color'],
                   calculate: function (data)
            	   {
            		   if (data.root)
            	       {
            			   return 'a-tree-glyph ametysicon-folder249';
            	       }
            		   else
            		   {
            			   if (data.color)
        				   {
            				   return 'a-tree-glyph tag-icon ametysicon-folder250 ' + data.class + '-' + data.color;
            			   }
            			   else
            			   {
            				   return 'a-tree-glyph tag-icon ametysicon-folder250 ' + data.class + '-default';
            			   }
            		   }
            	   }
               },
               {
            	   name: 'tooltipIconCls',
            	   calculate: function (data)
            	   {
            		   if (data.root)
            	       {
            			   return 'ametysicon-folder249';
            	       }
            		   else
            		   {
            			   return 'tag-icon ametysicon-folder250';
            		   }
            	   }
               },
               { name: 'disabled', type: 'boolean', defaultValue: false },
               { name: 'cls', defaultValue: ''},
               { 
                   name : 'creationAllowed',
                   type: 'boolean',
                   defaultValue: null
               },
               { name: 'type', defaultValue: 'tag'}
             ]
});