/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
Ext.define('Ametys.plugins.workspaces.project.form.widget.WeekDays', {
    extend: "Ametys.form.widget.ComboBox",
    
    constructor: function (config)
    {
        config.multiple = true;
        config.naturalOrder = true;
        config.singleValueForMultiple = true;
        
        config.enumeration = [
            ["2", "{{i18n PLUGINS_WORKSPACES_CALENDAR_EVENT_PARAM_WORKING_DAY_MONDAY}}"],
            ["3", "{{i18n PLUGINS_WORKSPACES_CALENDAR_EVENT_PARAM_WORKING_DAY_TUESDAY}}"],
            ["4", "{{i18n PLUGINS_WORKSPACES_CALENDAR_EVENT_PARAM_WORKING_DAY_WEDNESDAY}}"],
            ["5", "{{i18n PLUGINS_WORKSPACES_CALENDAR_EVENT_PARAM_WORKING_DAY_THURSDAY}}"],
            ["6", "{{i18n PLUGINS_WORKSPACES_CALENDAR_EVENT_PARAM_WORKING_DAY_FRIDAY}}"],
            ["7", "{{i18n PLUGINS_WORKSPACES_CALENDAR_EVENT_PARAM_WORKING_DAY_SATURDAY}}"],
            ["1", "{{i18n PLUGINS_WORKSPACES_CALENDAR_EVENT_PARAM_WORKING_DAY_SUNDAY}}"]
        ]
        
        this.callParent(arguments);
    }
});