/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * @private
 * Project model.
 */
Ext.define('Ametys.plugins.workspaces.project.tool.ProjectsTool.ProjectEntry', { 
    extend: 'Ext.data.Model',
   
    fields: [
        { name: 'id', type: 'string' }, 
        { name: 'name', type: 'string' }, 
        { name: 'type', type: 'string', defaultValue: 'project' },
        
        { name: 'title', type: 'string' },
        { name: 'description', type: 'string' },
        { name: 'mailingList', type: 'string' },
        
        { name: 'valid', type: 'boolean', defaultValue: true },
        { name: 'creationDate', type: 'date', dateFormat: Ext.Date.patterns.ISO8601DateTime },
        
        { name: 'managers'},
        { name: 'categories'}, 
        { name: 'tags'} 
    ]
}); 
