/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
WorkspacesUtils = {
    
    COLORS: ['purple', 'pink', 'blue', 'green', 'teal', 'indigo', 'red', 'orange', 'lime', 'grey', 'amber', 'brown'],
    
    /**
     * Get the icon associated to file type
    */
    getFileTypeIcon: function (fileType) 
    {
        return AmetysFront.getPluginResourcesPrefix('workspaces') + '/img/document/type/' + fileType + '.svg'
    },

    /**
     * Get the user's image url
     * @param {Object} user The user
     * @param {Number} size The image size. Defaults to 30.
     * @return the url for current user's image
     */
    getUserImgUrl: function(user, size)
    {
        size = size || 30;
        return AmetysFront.getPluginDirectPrefix('core-ui') + '/user/' + (user.population || user.populationId) + '/' + encodeURIComponent(user.login) + '/image_' + size + "?lang=" + AmetysFront.getAppParameter('sitemapLanguage');             
    },
    
    /**
     * Get the user's image url
     * @param {Object} user The user
     * @param {Number} size The image size. Defaults to 30.
     * @return the url for current user's image
     */
    getUserOrAnonymousImgUrl: function(user, size)
    {
        if (user.login != null)
        {
            return this.getUserImgUrl(user, size);
        }
        else
        {
            return this.getAnonymousImgUrl(size);
        }
    },
    
    /**
     * Get the user's image url
     * @param {Object} user The user
     * @param {Number} size The image size. Defaults to 30.
     * @return the url for current user's image
     */
    getAnonymousImgUrl: function(size)
    {
        size = size || 30;
        return AmetysFront.getPluginDirectPrefix('core-ui') + '/user/default-image_' + size;             
    },
    
    /**
     * Get the uri of a resource of document's module 
     * @param {Object} file the file resource
     * @param {Boolean} download true to generate uri for download purpose
     * @return The resource uri
     */
    resolveResourceUri: function (file, download)
    {
        return AmetysFront.getPluginDirectPrefix("workspaces")
                + "/" 
                + AmetysFront.getAppParameter('projectName') 
                + "/_resource" 
                + file.encodedPath
                + "." 
                + file.fileExtension
                + (download ? "?download=true" : "");
    },
    
    /**
     * Get the uri of a resource image of document's module 
     * @param {Object} file the file resource
     * @param {String} type for resource's size. Can be "crop", "bounded" or empty.
     * @param {Number} height
     * @param {Number} width
     * @return The resource uri
     */
    resolveResourceImgUri: function (file, type, height, width)
    {
        var sizeSuffix = height + "x" + width;
        if (type == 'crop')
        {
            sizeSuffix = "_crop" + sizeSuffix;
        }
        else if (type == 'bounded')
        {
            sizeSuffix = "_max" + sizeSuffix;
        }
        else 
        {
            sizeSuffix = "_" + sizeSuffix;
        }
        
        return AmetysFront.getPluginDirectPrefix("workspaces")
                + "/" 
                + AmetysFront.getAppParameter('projectName') 
                + "/_resource" 
                + file.encodedPath
                + sizeSuffix 
                + "." 
                + file.fileExtension;
    },
    
    /**
     * Return the color associated to this tag
     * @param {Object} tag the tag object
     * @return {String} the color's name
     */
    tagColor: function(tag)
    {
        if (tag.color)
        {
            return tag.color;
        }
        else
        {
            var s = tag.text;
            var hash = 0;
            for (var i = 0; s && i < s.length; i++)
            {
               hash += s.charCodeAt(i);
            }
            return this.COLORS[hash % this.COLORS.length];
        }
    },
    
    /**
     * True if is a touch device
     * @return {Boolean} true if is a touch device
     */
    isTouchDevice: function() 
    {
        if (window.membresIsTouchDevice === undefined)
        {
            // We can cache this value since in won't change in real life
            // And even, in Chrome emulator, the value only reflects the startup conf
            window.membresIsTouchDevice = (('ontouchstart' in window) ||
                (window.navigator.maxTouchPoints > 0) ||
                (window.navigator.msMaxTouchPoints > 0));
        }
        return window.membresIsTouchDevice;
    },
}
