<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:uriutils="org.ametys.core.util.URIUtils"
                              exclude-result-prefixes="i18n project resolver ametys">

    <xsl:variable name="lang" select="ametys:lang()" />
    <xsl:variable name="site-uri-prefix" select="ametys:siteUriPrefix()" />
    <xsl:variable name="site" select="ametys:site()" />
    <xsl:variable name="skin" select="ametys:skin()" />

    <xsl:variable name="maxMembers" select="3" />

    <xsl:template match="/projects">
        <html>
            <body>
                <ul class="ametys-projects__list ametys-q-panel__list">
                    <!-- Order by favorites then title -->
                    <xsl:apply-templates select="project">
                        <xsl:sort select="@favorite" order="descending" />
                        <xsl:sort select="title" />
                    </xsl:apply-templates>
                </ul>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="project">
        <li class="ametys-projects__list_item">
            <div class="ametys-projects__info">
                <!-- Not yet implemented -->
                <!-- <xsl:apply-templates select="." mode="new"/> -->

                <xsl:apply-templates select="." mode="image" />

                <div class="ametys-projects__info_descript">
                    <div class="ametys-projects__info_descript__top">
                        <xsl:apply-templates select="." mode="title" />

                        <xsl:apply-templates select="." mode="tag" />
                    </div>
                    <div class="ametys-projects__info_descript__bottom">

                        <xsl:apply-templates select="." mode="manager" />

                        <xsl:apply-templates select="." mode="members" />
                    </div>
                </div>
            </div>
        </li>
    </xsl:template>

    <xsl:template match="project" mode="new">
        <span class="ametys-indicator ametys-indicator--bordered ametys-indicator--danger"></span>
    </xsl:template>

    <xsl:template match="project" mode="image">
        <xsl:variable name="imgUrl" select="resolver:resolveCroppedImage('site-parameter', concat(site/@name, ';illustration'), 80, 100, false(), true())" />
        <div class="ametys-projects__msg_img ametys-projects__msg_img-none">
            <img alt="" src="{$imgUrl}" />
            
            <span class="ametys-projects_msg_img_corner"></span>
            
            <xsl:apply-templates select="." mode="favorite" />
        </div>
    </xsl:template>

    <xsl:template match="project" mode="favorite">
        <button class="ametys-projects-favorite" data-project-favorite="{@favorite}" data-project-name="{@name}" title="plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_PROJECTS_MY_PROJECTS_ADD_FAVORITE" i18n:attr="title">
            <xsl:if test="@favorite = 'true'">
                <xsl:attribute name="class">ametys-projects-favorite ametys-projects-favorite--active</xsl:attribute>
                <xsl:attribute name="title">plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_PROJECTS_MY_PROJECTS_REMOVE_FAVORITE</xsl:attribute>
            </xsl:if>
            <i class="fas fa-star"></i>
            <i class="far fa-star"></i>
        </button>
    </xsl:template>

    <xsl:template match="project" mode="title">
        <div class="ametys-q-panel__list_tmd">
            <a class="mb-0" href="{url}">
                <i class="fas fa-dice-d6" aria-hidden="true"></i>
                <xsl:value-of select="title" />
            </a>
        </div>
    </xsl:template>

    <xsl:template match="project" mode="tag">
        <div class="ametys-projects-tag" style="background-color: {category/@color}">
            <xsl:value-of select="category" />
        </div>
    </xsl:template>

    <xsl:template match="project" mode="manager">
        <div class="ametys-projects__author">
            <xsl:variable name="userImg">
                <xsl:call-template name="user-img-url">
                    <xsl:with-param name="login" select="manager[position() = 1]/@login" />
                    <xsl:with-param name="population" select="manager[position() = 1]/@population" />
                </xsl:call-template>
            </xsl:variable>
            <img alt="" src="{$userImg}" />
            <span>
                <xsl:value-of select="manager[position() = 1]/fullname" />
            </span>
        </div>
    </xsl:template>

    <xsl:template match="project" mode="members">
        <xsl:if test="members/@total > 1">
            <ul class="ametys-projects-users">
                <xsl:for-each select="manager[position() &gt; 1 and position() &lt;= number($maxMembers + 1)]">
                    <xsl:variable name="userImg">
                        <xsl:call-template name="user-img-url">
                            <xsl:with-param name="login" select="@login" />
                            <xsl:with-param name="population" select="@population" />
                        </xsl:call-template>
                    </xsl:variable>
                    <li><img alt="{fullname}" src="{$userImg}" /></li>
                </xsl:for-each>

                <xsl:variable name="remainMembers" select="number($maxMembers - count(manager[position() &gt; 1]))" />
                <xsl:for-each select="members/member[position() &lt;= $remainMembers]">
                    <xsl:variable name="userImg">
                        <xsl:call-template name="user-img-url">
                            <xsl:with-param name="login" select="@login" />
                            <xsl:with-param name="population" select="@population" />
                        </xsl:call-template>
                    </xsl:variable>
                    <li><img alt="{fullname}" src="{$userImg}" /></li>
                </xsl:for-each>

                <xsl:if test="members/@total > $maxMembers + 1">
                    <li class="more">
                        <span class="ametys-projects-users-plus">+<xsl:value-of select="members/@total - $maxMembers - 1" /></span>
                    </li>
                </xsl:if>
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template name="user-img-url">
        <xsl:param name="login" /><!-- user's login -->
        <xsl:param name="population" /><!-- user's population id -->
        <xsl:param name="imgWidth">32</xsl:param>                                            <!-- dimension of user's avatar -->
        <xsl:value-of select="concat($site-uri-prefix, '/_plugins/core-ui/user/', $population, '/', uriutils:encodePath($login), '/image_', $imgWidth, '?lang=', $lang)" />
    </xsl:template>

</xsl:stylesheet>