<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent">
    <xsl:template match="/notification">
        <notification>
            <xsl:call-template name="title"/>
            <xsl:call-template name="body"/>
        </notification>
    </xsl:template>

    <xsl:template name="title">
        <!-- It's not possible to set the attribute of an html element of the i18n key with a i18n param
            It will be done by the XSL after. Provide the data in an attribute of the title element here.
            In the i18n key, set the name of this attribute in an attribute data-href of the a element.
            The rest will be done by the skin -->
        <title root-data="true" projectURL="{project/url}">
            <i18n:translate>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_{/notification/eventKey}_TITLE" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="issuerFullname"><xsl:value-of select="issuer/user/fullname"/></i18n:param>
                <i18n:param name="projectTitle"><xsl:value-of select="project/title"/></i18n:param>
                <i18n:param name="projectUrl"><xsl:value-of select="project/url"/></i18n:param>
            </i18n:translate>
        </title>
    </xsl:template>
    
    <xsl:template name="body">
        <sections>
            <xsl:call-template name="section"/>
        </sections>
    </xsl:template>
    
    <xsl:template name="section">
        <section>
            <xsl:call-template name="section-hint"/>
            <xsl:call-template name="section-items"/>
            <xsl:call-template name="section-comments"/>
            <xsl:call-template name="section-button"/>
            <xsl:call-template name="section-link"/>
        </section>
    </xsl:template>
    
    <xsl:template name="section-hint"/>
    
    <xsl:template name="section-items">
        <items>
            <xsl:apply-templates select="activity"/>
        </items>
    </xsl:template>
    
    <xsl:template match="activity" mode="author">
        <author>
            <login><xsl:value-of select="/notification/issuer/user/@login"/></login>
            <populationId><xsl:value-of select="/notification/issuer/user/@population"/></populationId>
            <xsl:copy-of select="/notification/issuer/user/*"/>
        </author>
    </xsl:template>
    
    <xsl:template match="activity" mode="date">
        <date><xsl:value-of select="date"/></date>
    </xsl:template>
    
    <xsl:template name="section-comments"/>
    
    <xsl:template name="section-button">
        <button>
            <text>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
            </text>
            <href><xsl:call-template name="section-button-href" /></href>
            <width>300</width>
        </button>
    </xsl:template>
    
    <xsl:template name="section-button-href">
        <xsl:choose>
            <xsl:when test="modulePageId != ''"><xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="section-link"/>

</xsl:stylesheet>