<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:uri="org.ametys.core.util.URIUtils"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent">
    
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>
    
    <xsl:template name="body">
        <sections>
            <xsl:call-template name="section"/>
            
            <!-- Insert previous awswers -->
            <xsl:call-template name="previous-comments"/>
            
	        <xsl:if test="deleted">
	            <section>
	               <xsl:call-template name="workspace-button"/>
	            </section>
            </xsl:if>
        </sections>
    </xsl:template>
    
    <xsl:template name="previous-comments">
        <!-- Preview comments -->
            <xsl:variable name="previousComments" select="comments/comment[not(@currentActivity = 'true')]"/>
            <xsl:if test="count($previousComments) > 0">
                <xsl:variable name="multipleSuffix"><xsl:if test="count($previousComments) > 1">S</xsl:if></xsl:variable>
                <section>
                    <hint>
                        <i18n:translate>
                            <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_THREAD_PREVIOUS_COMMENT{$multipleSuffix}" i18n:catalogue="plugin.workspaces"/>
                        </i18n:translate>
                    </hint>
                    <items>
                        <!-- We sort by ascending order to have the item appears in chronological order -->
                        <xsl:apply-templates select="$previousComments[position() &gt; (last() - 5)]" mode="previousAnswer">
                            <xsl:sort select="creationDate" order="ascending"></xsl:sort>
                        </xsl:apply-templates>
                        <nobg></nobg>
                    </items>
                </section>
            </xsl:if>
    </xsl:template>
    
    <xsl:template match="comment" mode="previousAnswer">
        <item type="comment">
	        <content>
	            <xsl:value-of select="content"/>
	        </content>
            <datetime><xsl:value-of select="creationDate"/></datetime>
	        <author>
                <fullname><xsl:value-of select="authorName"/></fullname>
                <login><xsl:value-of select="login"/></login>
                <populationId><xsl:value-of select="populationId"/></populationId>
	        </author>
        </item>
    </xsl:template>
    
    <xsl:template match="activity[type = 'forumthread.created' or type = 'forumthread.modified' or type = 'forumthread.closed' or type = 'forumthread.deleted']">
        <item type="forum">
            <xsl:apply-templates select="." mode="title"/>
            <xsl:apply-templates select="." mode="author"/>
            <xsl:copy-of select="threadCategory"/>
            <xsl:apply-templates select="." mode="date"/>
            <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
        </item>
    </xsl:template>
    
    <xsl:template match="activity[type = 'forumthread.commented']">
        <item type="forum">
            <xsl:apply-templates select="." mode="title"/>
            <xsl:copy-of select="threadCategory"/>
            <xsl:apply-templates select="." mode="thread-author"/>
            <xsl:apply-templates select="." mode="thread-date"/>
            <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
            <comments>
                <comment>
                    <datetime><xsl:value-of select="date"/></datetime>
                    <xsl:apply-templates select="." mode="comment-author"/>
                    <xsl:apply-templates select="." mode="content"/>
                </comment>
            </comments>
        </item>
    </xsl:template>
    
    <xsl:template match="activity[type = 'forumthread.accepted']">
        <item type="forum">
            <xsl:apply-templates select="." mode="title"/>
            <xsl:copy-of select="threadCategory"/>
            <xsl:apply-templates select="." mode="thread-author"/>
            <xsl:apply-templates select="." mode="thread-date"/>
            <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
            <comments>
                <comment>
                    <datetime><xsl:value-of select="date"/></datetime>
                    <xsl:apply-templates select="." mode="comment-author"/>
                    <xsl:apply-templates select="." mode="content"/>
                    <accepted/>
                </comment>
            </comments>
        </item>
    </xsl:template>
    
    <xsl:template match="activity[type = 'forumthread.reported']">
        <item type="forum">
            <xsl:apply-templates select="." mode="title"/>
            <xsl:copy-of select="threadCategory"/>
            <xsl:apply-templates select="." mode="thread-author"/>
            <xsl:apply-templates select="." mode="thread-date"/>
            <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
            <comments>
                <comment>
                    <datetime><xsl:value-of select="commentCreationDate"/></datetime>
                    <xsl:apply-templates select="." mode="comment-author"/>
                    <xsl:apply-templates select="." mode="content"/>
                </comment>
            </comments>
        </item>
    </xsl:template>

    <xsl:template match="activity" mode="title">
        <title><xsl:value-of select="threadTitle"/></title>
    </xsl:template>

    <xsl:template match="activity" mode="content">
        <content>
            <xsl:value-of select="content" disable-output-escaping="yes"/>
        </content>
    </xsl:template>
    
    <xsl:template match="activity" mode="thread-author">
        <author>
            <login><xsl:value-of select="threadAuthor/@login"/></login>
            <populationId><xsl:value-of select="threadAuthor/@populationId"/></populationId>
            <fullname><xsl:value-of select="threadAuthor"/></fullname>
        </author>
    </xsl:template>
    
    <xsl:template match="activity" mode="thread-date">
        <date><xsl:value-of select="threadCreationDate"/></date>
    </xsl:template>
        
    <xsl:template match="activity" mode="comment-author">
        <author>
            <login><xsl:value-of select="commentAuthor/@login"/></login>
            <populationId><xsl:value-of select="commentAuthor/@populationId"/></populationId>
            <fullname><xsl:value-of select="commentAuthorName"/></fullname>
        </author>
    </xsl:template>
    
    <xsl:template match="comment" mode="content">
        <content>
            <xsl:value-of select="message"/>
        </content>
    </xsl:template>
    
    <!-- When thread is deleting, button to go to workspace will be inserted after previous answer  -->
    <!-- Ajust margin-bottom according previous answer or not -->
    <xsl:template name="section-button">
        <xsl:if test="not(deleted)">
            <xsl:variable name="previousComments" select="comments/comment[not(@currentActivity = 'true')]"/>
            <button id="section-button">
                <text>
                    <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_FORUMTHREAD_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
                </text>
                <href><xsl:call-template name="section-button-href" /></href>
                <margin-bottom>
                    <xsl:choose>
                        <xsl:when test="count($previousComments) > 0">0</xsl:when>
                        <xsl:otherwise>50</xsl:otherwise>
                    </xsl:choose>
                </margin-bottom>
                <width><xsl:value-of select="."/></width> 
            </button>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="section-button-href">
        <xsl:choose>
            <xsl:when test="activity/threadId != ''"><xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/><xsl:text>#thread-</xsl:text><xsl:value-of select="activity/threadId"/></xsl:when>
            <xsl:when test="modulePageId != ''"><xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="workspace-button">
        <xsl:variable name="previousComments" select="comments/comment[not(@currentActivity = 'true')]"/>
        <button id="workspace-button">
            <text>
                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
            </text>
            <href>
                <xsl:choose>
                    <xsl:when test="modulePageId != ''"><xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
                </xsl:choose>
            </href>
            <width>300</width>
            <xsl:if test="count($previousComments) > 0">
                <margin-top>10</margin-top>
            </xsl:if>
            <margin-bottom>50</margin-bottom>
        </button>
    </xsl:template>
    
</xsl:stylesheet>
