<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent">
    
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>
    
    <xsl:template match="activity">
        <item type="page">
            <title><xsl:value-of select="pageTitle"/></title>
            <id><xsl:value-of select="pageId"/></id>
            <xsl:apply-templates select="." mode="date"/>
            <xsl:apply-templates select="." mode="author"/>
            <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
            <xsl:if test="nbOfOccurrence &gt; 1">
                <multiple>true</multiple>
            </xsl:if>
        </item>
        
    </xsl:template>

    <xsl:template match="activity" mode="title">
        <title><xsl:value-of select="taskTitle"/></title>
    </xsl:template>
    
    <xsl:template name="section-button-href" >
        <xsl:choose>
            <xsl:when test="count(activity) = 1 and /notification/eventKey != 'MINISITE_PAGE_DELETED'">
                <xsl:value-of select="resolver:resolve('page', activity/pageId, false(), true())"/>
            </xsl:when>
            <xsl:when test="modulePageId != ''">
                <xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>