<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:avatar="org.ametys.plugins.core.ui.user.ProfileImageResolverHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:variable name="i18nparam"><param/></xsl:variable>
    <xsl:variable name="comment-date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_LAST_MODIFIED_COMMENT_DATE_FORMAT', $lang, $i18nparam)"></xsl:variable>
                                                                            
    <xsl:template name="accepted-style">
        <xsl:attribute name="style">line-height: 1.4; font-size: 14px; font-family: <xsl:value-of select="$font-family"/>; color: <xsl:value-of select="$text-color-dark"/>;font-weight: 500; padding-bottom: 5px;</xsl:attribute>
    </xsl:template>                                        
    <xsl:template name="comment-author-style">
        <xsl:attribute name="style">line-height: 1.2; font-family: <xsl:value-of select="$font-family"/>; font-weight: 700; font-size: 12px; color: <xsl:value-of select="$text-color-dark"/>;</xsl:attribute>
    </xsl:template>

    <xsl:template name="comment-date-style">
        <xsl:attribute name="style">line-height: 1.2; font-family: <xsl:value-of select="$font-family"/>; font-style: italic; font-size: 12px; color: <xsl:value-of select="$text-color-dark"/>;</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="comment-text-style">
        <xsl:attribute name="style">line-height: 1.4; font-family: <xsl:value-of select="$font-family"/>; font-size: 12px; color: <xsl:value-of select="$text-color"/>;</xsl:attribute>
    </xsl:template>
        
    <!-- +
         | Helper for sub item as comments, posts, ..
         + -->
    <xsl:template name="comment">
        <xsl:param name="width" select="$max-width - 60"/>
        <xsl:param name="new">true</xsl:param>
        <xsl:param name="author"/>
        <xsl:param name="accepted"/>
        <xsl:param name="date"/>
        <xsl:param name="content"/>
        <xsl:param name="level"/>2
        <xsl:param name="margin-left" select="20 + 20*($level - 1)"/>
        <xsl:param name="margin-right" select="20"/>
        <xsl:param name="border-bottom"/>
        <xsl:param name="padding-top">15</xsl:param>
        <xsl:param name="padding-bottom">15</xsl:param>
        <xsl:param name="padding-left">15</xsl:param>
        <xsl:param name="padding-right">15</xsl:param>
        <xsl:param name="no-margin-right"/>
        
        <xsl:variable name="background-color">
            <xsl:choose>
                <xsl:when test="$new = 'false'"><xsl:value-of select="$bg-highlight"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$primary-light"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="border-bottom-size">
            <xsl:choose>
                <xsl:when test="$border-bottom = true()">1</xsl:when>
                <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="border-color">
            <xsl:choose>
                <xsl:when test="$new = 'false'"><xsl:value-of select="$border-highlight"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$primary"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <div >
            <xsl:attribute name="style">max-width:  <xsl:value-of select="$width"/>px; margin: 0px auto;</xsl:attribute>
          
            <table>
                <xsl:call-template name="table-layout-attributes" />
                <tbody>
                    <tr>
                        <xsl:call-template name="row-horizontal-spacer">
                            <xsl:with-param name="width" select="$margin-left"/>
                        </xsl:call-template>
                        <td style="direction: ltr; font-size: 0px; padding: 0px; word-break: break-word; background-color: {$background-color}; border-left: 2px solid {$border-color}; border-bottom : {$border-bottom-size}px solid {$border-color}2e;">
                            <table>
                                <xsl:call-template name="table-layout-attributes"/>
                                <tbody>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$padding-top"/>
                                        <xsl:with-param name="colspan">3</xsl:with-param>
                                    </xsl:call-template>
                                    
                                    <tr>
                                        <xsl:call-template name="row-horizontal-spacer">
                                            <xsl:with-param name="width" select="$padding-left"/>
                                        </xsl:call-template>
                                        <td>
                                            <xsl:call-template name="td-layout-attributes"/>
                                            
                                            <!-- Comment -->
                                            <table>
                                                <xsl:call-template name="table-layout-attributes"/>
                                                <tbody>
                                                    <tr>
                                                        <td width="34" style="padding: 0px; direction: ltr; font-size: 0px; word-break: break-word;" valign="top">
				                                            <!-- Author icon -->
				                                            <div style="width: 34px; height: 34px; display: inline-block;">
                                                                <xsl:variable name="lang"><xsl:value-of select="ametys:lang()"/></xsl:variable>

											                    <xsl:variable name="bordercolor">
											                        <xsl:choose>
											                            <!-- We remove the author when multiple user made the same action -->
											                            <xsl:when test="$accepted = 'true'">9575CD</xsl:when>
											                            <xsl:otherwise>fff</xsl:otherwise>
											                        </xsl:choose>
											                    </xsl:variable>
											                    
				                                                <img width="34" height="34" src="{avatar:resolveAsBase64(exslt:node-set($author)/login, exslt:node-set($author)/populationId, 34, $lang)}" alt="{exslt:node-set($author)/fullname}" id="{exslt:node-set($author)/fullname}" style="display: block; border: solid 3px #{$bordercolor}; border-radius: 50%; outline: none; text-decoration: none;"/>
				                                            </div>
				                                        </td>
                                                        <xsl:call-template name="row-horizontal-spacer">
				                                            <xsl:with-param name="width">15</xsl:with-param>
				                                        </xsl:call-template>
                                                        <td align="left">
                                                            <xsl:call-template name="td-layout-attributes"/>
                                                            <!-- Accepted -->
											                <xsl:if test="$accepted = 'true'">
                                                                <div>
	                                                                <xsl:call-template name="accepted-style"/>
	                                                                
														            <i18n:translate>
														                <i18n:text i18n:key="PLUGINS_WORKSPACES_FORUM_ACCEPTED_ANSWER_ANSWER_CONTENT_LABEL" i18n:catalogue="plugin.workspaces"/>
														                <i18n:param name="commentAuthor"><xsl:value-of select="exslt:node-set($author)/fullname"/></i18n:param>
														            </i18n:translate>
	
															        <div style="width: 20px; height: 20px; display: inline-block;">
															            <img src="{ametys:pluginImageBase64('workspaces', 'img/mail/icon-check.png')}" alt="" width="20" height="20" style="padding-left: 5px;vertical-align: middle;"/>
															        </div>
                                                                </div>
											                </xsl:if>
                                                            <!-- Author name -->
                                                            <div>
                                                                <xsl:call-template name="comment-author-style"/>
                                                                <xsl:value-of select="exslt:node-set($author)/fullname"/>
                                                                <xsl:value-of select="$border-bottom"/>
                                                            </div>
				                                            <xsl:call-template name="table-vertical-spacer">
				                                                <xsl:with-param name="height">0</xsl:with-param>
				                                            </xsl:call-template>
				                                            <!-- Date -->
                                                            <div>
                                                                <xsl:call-template name="comment-date-style"/>
                                                                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$comment-date-format}"><xsl:value-of select="$date"/></i18n:date>
                                                            </div>
                                                            <!-- Text -->
				                                            <div>
                                                                <xsl:call-template name="comment-text-style"/>
                                                                <xsl:copy-of select="$content"/>
                                                            </div>
				                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                        <xsl:call-template name="row-horizontal-spacer">
                                            <xsl:with-param name="width" select="$padding-right"/>
                                        </xsl:call-template>
                                    </tr>
                                    
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$padding-bottom"/>
                                        <xsl:with-param name="colspan">3</xsl:with-param>
                                    </xsl:call-template>
                                </tbody>
                            </table>
                        </td>
                        <xsl:call-template name="row-horizontal-spacer">
                            <xsl:with-param name="width" select="$margin-right"/>
                        </xsl:call-template>
                    </tr>
                </tbody>
            </table>
        </div>
    </xsl:template>    
</xsl:stylesheet>