<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
    
    <!-- +
         | Helper for images container
         + -->
    <xsl:template name="images-container">
        <xsl:param name="width">600</xsl:param>
        <xsl:param name="margin-top">0</xsl:param>
        <xsl:param name="margin-bottom">25</xsl:param>
        <xsl:param name="padding-left">20</xsl:param>
        <xsl:param name="padding-right">20</xsl:param>
        <xsl:param name="srcImage1"/>
        <xsl:param name="altImage1"/>
        <xsl:param name="srcImage2"/>
        <xsl:param name="altImage2"/>
        <xsl:param name="withBorder" select="false()"/>
        
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        
        <div style="max-width: {$width}px; margin: 0px auto;">
            <table>
                <xsl:call-template name="table-layout-attributes"/>
                <tbody>
                <tr>
                    <td height="" style="direction: ltr; font-size: 0px; padding: 0px; word-break: break-word; border-radius: 8px;  overflow: hidden; ">
                        <table>
                            <xsl:call-template name="table-layout-attributes"/>
                            <tbody>
                                <xsl:call-template name="row-vertical-spacer">
                                    <xsl:with-param name="height" select="$margin-top"/>
                                    <xsl:with-param name="colspan">3</xsl:with-param>
                                </xsl:call-template>
                                <tr>
                                    <xsl:call-template name="row-horizontal-spacer">
                                        <xsl:with-param name="width" select="$padding-left"/>
                                    </xsl:call-template>
                                    <td>
                                        <xsl:call-template name="table-layout-attributes"/>
                                        <table>
                                            <xsl:call-template name="table-layout-attributes"/>
                                            <tbody>
                                                <tr>
                                                    <xsl:if test="$srcImage1">
                                                        <td align="center" valign="top" style="width: 50%; margin: 0; padding: 0 7px 0 0;">
                                                            <img width="100%" style="max-width: 100%; height: auto; outline: none; border: none;" src="{$srcImage1}" alt="{$altImage1}"/>
                                                        </td>
                                                    </xsl:if>
                                                    <xsl:if test="$srcImage2">
                                                        <td align="center" valign="top" style="width: 50%; margin: 0; padding: 0 0 0 7px;">
                                                            <img width="100%" style="max-width: 100%; height: auto; outline: none; border: none;" src="{$srcImage2}" alt="{$altImage2}"/>
                                                        </td>
                                                    </xsl:if>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                    <xsl:call-template name="row-horizontal-spacer">
                                        <xsl:with-param name="width" select="$padding-right"/>
                                    </xsl:call-template>
                                </tr>
                                
                                <xsl:choose>
                                    <xsl:when test="$withBorder">
                                        <tr>
                                            <xsl:call-template name="row-horizontal-spacer">
                                                <xsl:with-param name="width" select="$padding-left"/>
                                            </xsl:call-template>
                                            
                                            <td height="{$margin-bottom}">
                                              <xsl:attribute name="style">border-bottom: 2px solid <xsl:value-of select="$separator-color"/>; direction: ltr; font-size: 0px; padding: 0px; word-break: break-word;</xsl:attribute>
                                              <xsl:call-template name="placeholder"/>
                                            </td>
            
                                            <xsl:call-template name="row-horizontal-spacer">
                                                <xsl:with-param name="width" select="$padding-right"/>
                                            </xsl:call-template>
                                        </tr>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:call-template name="row-vertical-spacer">
                                            <xsl:with-param name="colspan">3</xsl:with-param>
                                            <xsl:with-param name="height" select="$margin-bottom"/>
                                        </xsl:call-template>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tbody>
                        </table>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
        <xsl:call-template name="msoif-close"/>
    </xsl:template>
</xsl:stylesheet>