<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
    
    <!-- +
         | Helper to diplay project's title with link on project's url
         + -->
    <xsl:template name="project-title">
        <xsl:param name="margin-top">30</xsl:param>
        <xsl:param name="margin-bottom">15</xsl:param>
        <xsl:param name="width" select="$max-width - 60"/>
        <xsl:param name="url"/>
        <xsl:param name="title"/>
        
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
    
        <div style="max-width: {$width}px; margin: 0px auto">
            <table>
                <xsl:call-template name="table-layout-attributes" />
                <tbody>
                    <tr>
                        <td>
                            <xsl:call-template name="td-layout-attributes" />
                            <table>
                                <xsl:call-template name="table-layout-attributes" />
                                <tbody>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$margin-top" />
                                    </xsl:call-template>
                                    <tr>
                                        <td>
                                            <xsl:call-template name="td-layout-attributes" />
    
                                            <div style="font-weight: 600; font-size: 18px; text-align: left; color: {$primary}">
                                                <xsl:call-template name="project-title-icon"/>
                                                <xsl:text>&#160;&#160;</xsl:text>
                                                <a
                                                    style="color: {$primary}; font-family: {$font-family};"
                                                    href="{$url}">
                                                    <xsl:value-of select="$title"/>
                                                 </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$margin-bottom" />
                                    </xsl:call-template>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <xsl:call-template name="msoif-close" />
    </xsl:template>
    
    <xsl:template name="project-title-icon">
        <img src="{ametys:pluginImageBase64('workspaces', 'img/mail/icon-cube.png')}" alt="" width="20" height="27" valign="middle"/> 
    </xsl:template>
       
</xsl:stylesheet>