<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:datetime="http://ametys.org/datetime/4.2"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
                              
    <xsl:import href="plugin:core://stylesheets/helper/datetime.xsl"/>
    
    <xsl:variable name="input-date-format">yyyy-MM-dd'T'HH:mm:ss.SSSXXX</xsl:variable>
    
     <!-- 
    <item type="calendar">
        <color>#4c4c4c</color>
        <title>foo</title>
        <startDate>yyyy-MM-ddTHH:mm.sssX</startDate>
        <endDate>yyyy-MM-ddTHH:mm.sssX</endDate>
        <fullDay>true|false</fullDay>
        <recurrence until="yyyy-MM-ddTHH:mm.sssX">NEVER|WEEKLY|MONTHLY|...</recurrence>
    <item>
     -->
     
    <xsl:template match="item[@type='calendar']" mode="item-content">
        <table align="left" border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse: collapse; border-spacing: 0px; width: 100%;">
            <tbody>
                <tr>
                    <td width="40" style="padding: 0px; direction: ltr; font-size: 0px; word-break: break-word;" valign="top">
                        <xsl:apply-templates select="." mode="event-day"/>
                    </td>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">14</xsl:with-param>
                    </xsl:call-template>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">3</xsl:with-param>
                        <xsl:with-param name="bgcolor" select="color"/>
                    </xsl:call-template>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">7</xsl:with-param>
                    </xsl:call-template>
                    <td style="direction: ltr; font-size: 0px; padding: 0px; word-break: break-word;">
                        <xsl:apply-templates select="." mode="event-date-range"/>
                        
                        <xsl:call-template name="table-vertical-spacer"/>
                        
                        <xsl:apply-templates select="." mode="event-recurrence"/>
                        
                        <xsl:apply-templates select="." mode="event-title"/>
                    </td>

                    <!-- ICS icon -->
                    <xsl:if test="icsLink != ''">
				        <td width="70" style="padding: 0px; direction: ltr; font-size: 0px; word-break: break-word;" valign="top" align="right">
				            <div style="line-height: 22px; font-size: 14px; font-family: {$font-family}; font-weight: 300;">
				                <a href="{icsLink}">
				                    <img src="{ametys:pluginImageBase64('workspaces', 'img/mail/icon-time.png')}" i18n:attr="alt" alt="plugin.workspaces:PROJECT_MAIL_NOTIFICATION_BODY_ATTACHMENT_ICON_ALT" width="15" height="11" valign="top"/>
				                </a>
				                &#160;
				            </div>
				        </td>
                    </xsl:if>
                    
                </tr>
                <xsl:apply-templates select="resources"/>
            </tbody>
        </table>
    </xsl:template>
    
    <xsl:template match="item" mode="event-day">
       <div style="font-weight: 300; font-size: 24px; line-height: 1; color: {$text-color-dark}; font-family: {$font-family};">
           <i18n:date type="date" pattern="dd" src-pattern="{$input-date-format}"><xsl:value-of select="startDate"/></i18n:date>
       </div>
       <div style="font-weight: 600; font-size: 14px; line-height: 1; color: {$text-color-dark}; font-family: {$font-family}; text-transform: uppercase;">
           <i18n:date type="date" pattern="MMM" src-pattern="{$input-date-format}"><xsl:value-of select="startDate"/></i18n:date>
       </div>
    </xsl:template>
    
    <xsl:template match="item" mode="event-recurrence">
        <xsl:if test="recurrence != 'NEVER' and recurrence != ''">
            <xsl:variable name="untilSuffix"><xsl:if test="recurrence/@until != ''">_UNTIL</xsl:if></xsl:variable>
            <xsl:variable name="recurrence">
                <i18n:translate>
                    <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_EVENT_RECURRENT_{recurrence}{$untilSuffix}" i18n:catalogue="plugin.workspaces"/>
                    <i18n:param name="untilDate">
                        <i18n:date type="date" pattern="medium" src-pattern="{$input-date-format}"><xsl:value-of select="recurrence/@until"/></i18n:date>
                    </i18n:param>
                </i18n:translate>
            </xsl:variable>
            
            <div style="font-weight: 300; font-size: 12px; line-height: 1.4; color: {$text-color}; font-family: {$font-family};">
                <xsl:copy-of select="exslt:node-set($recurrence)/node()"/>
            </div>
            <xsl:call-template name="table-vertical-spacer"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item" mode="event-date-range">
        <xsl:variable name="i18nparam"><param/></xsl:variable>
        <xsl:variable name="date-range">
            <xsl:choose>
                <xsl:when test="fullDay = 'true'">
                    <!-- Full day event -->
                    <xsl:choose>
                        <xsl:when test="datetime:sameDate(startDate, endDate)">
                            <!-- Same day -->
                            <xsl:variable name="date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_EVENT_DATE_FULLDAY_FORMAT', $lang, $i18nparam)"></xsl:variable>
                            <i18n:date type="date" pattern="{$date-format}" src-pattern="{$input-date-format}"><xsl:value-of select="startDate"/></i18n:date>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- Multiple day -->
                            <xsl:variable name="start-date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_EVENT_DATE_FULLDAYS_FORMAT_START', $lang, $i18nparam)"></xsl:variable>
                            <xsl:variable name="end-date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_EVENT_DATE_FULLDAYS_FORMAT_END', $lang, $i18nparam)"></xsl:variable>
                            <i18n:date-time type="date" pattern="{$start-date-format}" src-pattern="{$input-date-format}"><xsl:value-of select="startDate"/></i18n:date-time>
                            <i18n:date-time type="date" pattern="{$end-date-format}" src-pattern="{$input-date-format}"><xsl:value-of select="endDate"/></i18n:date-time>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <!--Not full day -->
                    <xsl:choose>
                        <xsl:when test="datetime:sameDate(startDate, endDate)">
                            <!-- Same day -->
                            <xsl:variable name="start-date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_EVENT_DATE_SAME_DAY_TIME_SLOT_FORMAT_START', $lang, $i18nparam)"></xsl:variable>
                            <xsl:variable name="end-date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_EVENT_DATE_SAME_DAY_TIME_SLOT_FORMAT_END', $lang, $i18nparam)"></xsl:variable>
                            <i18n:date-time type="date" pattern="{$start-date-format}" src-pattern="{$input-date-format}"><xsl:value-of select="startDate"/></i18n:date-time>
                            <i18n:date-time type="date" pattern="{$end-date-format}" src-pattern="{$input-date-format}"><xsl:value-of select="endDate"/></i18n:date-time>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- different day -->
                            <xsl:variable name="start-date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_EVENT_DATE_TIME_SLOT_FORMAT_START', $lang, $i18nparam)"></xsl:variable>
                            <xsl:variable name="end-date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_EVENT_DATE_TIME_SLOT_FORMAT_END', $lang, $i18nparam)"></xsl:variable>
                            <i18n:date-time type="date" pattern="{$start-date-format}" src-pattern="{$input-date-format}"><xsl:value-of select="startDate"/></i18n:date-time>
                            <i18n:date-time type="date" pattern="{$end-date-format}" src-pattern="{$input-date-format}"><xsl:value-of select="endDate"/></i18n:date-time>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <div style="font-weight: 300; font-size: 12px; line-height: 1.4; color: {$text-color}; font-family: {$font-family};">
            <xsl:copy-of select="exslt:node-set($date-range)/node()"/>
        </div>
    </xsl:template>
    
    
    <xsl:template match="item" mode="event-title">
        <div style="font-weight: 500; font-size: 14px; line-height: 1.4; color: {$text-color-dark}; font-family: {$font-family};">
            <xsl:value-of select="title"/>
        </div>
    </xsl:template>
    
    <xsl:template match="resources">
        <xsl:call-template name="row-vertical-spacer">
            <xsl:with-param name="height">8</xsl:with-param>
            <xsl:with-param name="colspan">5</xsl:with-param>
        </xsl:call-template>
        <tr>
            <xsl:call-template name="row-horizontal-spacer">
                <xsl:with-param name="width">40</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="row-horizontal-spacer">
                <xsl:with-param name="width">14</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="row-horizontal-spacer">
                <xsl:with-param name="width">3</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="row-horizontal-spacer">
                <xsl:with-param name="width">7</xsl:with-param>
            </xsl:call-template>
            <td style="direction: ltr; font-size: 0px; padding: 0px; word-break: break-word;">
                <xsl:apply-templates select="resource"/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="resource">
          <span style="margin: 0 0 0 5px; display: inline-block; line-height: 24px; font-weight: 400; font-size: 12px; font-family: {$font-family}; color: {$text-color}; font-weight: 500; background-color: {$bg-highlight}; border-radius: 12px;">
            &#160;&#160; <img src="{ametys:pluginImageBase64('workspaces', 'img/mail/icon-resource.png')}" alt="" width="16" height="9" valign="middle"/> &#160; <xsl:value-of select="text()"/> &#160;&#160;
          </span>
    </xsl:template>
</xsl:stylesheet>