<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                exclude-result-prefixes="i18n ametys docbook project">
                
    <xsl:import href="docbookenhancement://docbook2htmleditor.xsl"/>
	
    <xsl:template match="docbook:person[@data-ametys-mention-user]">
        <xsl:variable name="status" select="project:getMemberStatus(string(@data-ametys-mention-user))"/>
        
        <xsl:choose>
            <xsl:when test="$status = 'allowed'">
		        <span class="ametys-mention ametys-mention-allowed" data-ametys-mention-user="{@data-ametys-mention-user}"><xsl:apply-templates/></span>
            </xsl:when>
            <xsl:when test="$status = 'not-allowed'">
		        <span class="ametys-mention ametys-mention-not-allowed" data-ametys-tooltip="PLUGINS_WORKSPACES_PROJECTS_MENTION_USER_NOT_MEMBER_TOOLTIP" i18n:attr="data-ametys-tooltip" data-ametys-mention-user="{@data-ametys-mention-user}"><xsl:apply-templates/></span>
            </xsl:when>
            <xsl:when test="$status = 'current-user'">
		        <span class="ametys-mention ametys-mention-own" data-ametys-mention-user="{@data-ametys-mention-user}"><xsl:apply-templates/></span>
            </xsl:when>
            </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>